/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicInputConnector;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.RenderThread;
import net.sf.fmj.media.renderer.audio.AudioRenderer;
import net.sf.fmj.media.rtp.util.RTPTimeBase;
import net.sf.fmj.media.rtp.util.RTPTimeReporter;
import net.sf.fmj.media.util.ElapseTime;

public class BasicRendererModule
extends BasicSinkModule
implements RTPTimeReporter {
    protected PlaybackEngine engine;
    protected Renderer renderer;
    protected InputConnector ic;
    protected int framesPlayed = 0;
    protected float frameRate = 30.0f;
    protected boolean framesWereBehind = false;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean opened = false;
    private int chunkSize = Integer.MAX_VALUE;
    private long lastDuration = 0L;
    private RTPTimeBase rtpTimeBase = null;
    private String rtpCNAME = null;
    RenderThread renderThread;
    private Object prefetchSync = new Object();
    private ElapseTime elapseTime = new ElapseTime();
    private long LEEWAY = 10L;
    private long lastRendered = 0L;
    private boolean failed = false;
    private boolean notToDropNext = false;
    private Buffer storedBuffer = null;
    private boolean checkRTP = false;
    private boolean noSync = false;
    final float MAX_RATE = 1.05f;
    final float RATE_INCR = 0.01f;
    final int FLOW_LIMIT = 20;
    boolean overMsg = false;
    int overflown = 10;
    float rate = 1.0f;
    long systemErr = 0L;
    static final long RTP_TIME_MARGIN = 2000000000L;
    boolean rtpErrMsg = false;
    long lastTimeStamp;
    static final int MAX_CHUNK_SIZE = 16;
    AudioFormat ulawFormat = new AudioFormat("ULAW");
    AudioFormat linearFormat = new AudioFormat("LINEAR");

    protected BasicRendererModule(Renderer renderer) {
        this.setRenderer(renderer);
        this.ic = new BasicInputConnector();
        if (renderer instanceof VideoRenderer) {
            this.ic.setSize(4);
        } else {
            this.ic.setSize(1);
        }
        this.ic.setModule(this);
        this.registerInputConnector("input", this.ic);
        this.setProtocol(1);
    }

    public void abortPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.prefetching = false;
        this.opened = false;
    }

    private int computeChunkSize(Format format) {
        if (format instanceof AudioFormat && (this.ulawFormat.matches(format) || this.linearFormat.matches(format))) {
            AudioFormat audioFormat = (AudioFormat)format;
            int n = audioFormat.getSampleSizeInBits() * audioFormat.getChannels() / 8;
            if (n == 0) {
                n = 1;
            }
            int n2 = (int)audioFormat.getSampleRate() * n / 16;
            return n2 / n * n;
        }
        return Integer.MAX_VALUE;
    }

    public void doClose() {
        this.renderThread.kill();
        if (this.renderer != null) {
            this.renderer.close();
        }
        if (this.rtpTimeBase != null) {
            RTPTimeBase.remove(this, this.rtpCNAME);
            this.rtpTimeBase = null;
        }
    }

    public void doDealloc() {
        this.renderer.close();
    }

    public void doFailedPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.opened = false;
        this.prefetching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void donePrefetch() {
        Object object = this.prefetchSync;
        synchronized (object) {
            if (!this.started && this.prefetching) {
                this.renderThread.pause();
            }
            this.prefetching = false;
        }
        if (this.moduleListener != null) {
            this.moduleListener.bufferPrefetched(this);
        }
    }

    public void doneReset() {
        this.renderThread.pause();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        if (!this.opened) {
            try {
                this.renderer.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                this.prefetchFailed = true;
                return false;
            }
            this.prefetchFailed = false;
            this.opened = true;
        }
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.prefetching = true;
        this.renderThread.start();
        return true;
    }

    protected boolean doProcess() {
        if ((this.started || this.prefetching) && this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
            if (this.renderer instanceof Drainable) {
                ((Drainable)((Object)this.renderer)).drain();
            }
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.stopAtTime(this);
            }
        }
        Buffer buffer = this.storedBuffer != null ? this.storedBuffer : this.ic.getValidBuffer();
        if (!this.checkRTP) {
            if ((buffer.getFlags() & 0x1000) != 0) {
                String string = this.engine.getCNAME();
                if (string != null) {
                    this.rtpTimeBase = RTPTimeBase.find(this, string);
                    this.rtpCNAME = string;
                    if (this.ic.getFormat() instanceof AudioFormat) {
                        Log.comment("RTP master time set: " + this.renderer + "\n");
                        this.rtpTimeBase.setMaster(this);
                    }
                    this.checkRTP = true;
                    this.noSync = false;
                } else {
                    this.noSync = true;
                }
            } else {
                this.checkRTP = true;
            }
        }
        this.lastTimeStamp = buffer.getTimeStamp();
        if (this.failed || this.resetted) {
            if ((buffer.getFlags() & 0x200) != 0) {
                this.resetted = false;
                this.renderThread.pause();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            this.storedBuffer = null;
            this.ic.readReport();
            return true;
        }
        boolean bl = this.scheduleBuffer(buffer);
        if (this.storedBuffer == null && buffer.isEOM()) {
            if (this.prefetching) {
                this.donePrefetch();
            }
            if ((buffer.getFlags() & 0x40) == 0 && buffer.getTimeStamp() > 0L && buffer.getDuration() > 0L && buffer.getFormat() != null && !(buffer.getFormat() instanceof AudioFormat) && !this.noSync) {
                this.waitForPT(buffer.getTimeStamp() + this.lastDuration);
            }
            this.storedBuffer = null;
            this.ic.readReport();
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.mediaEnded(this);
            }
            return true;
        }
        if (this.storedBuffer == null) {
            this.ic.readReport();
        }
        return bl;
    }

    public boolean doRealize() {
        this.chunkSize = this.computeChunkSize(this.ic.getFormat());
        this.renderThread = new RenderThread(this);
        this.engine = (PlaybackEngine)this.getController();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        super.doStart();
        if (!(this.renderer instanceof Clock)) {
            this.renderer.start();
        }
        this.prerolling = false;
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.renderThread.start();
        }
    }

    public void doStop() {
        this.started = false;
        this.prefetching = true;
        super.doStop();
        if (this.renderer != null && !(this.renderer instanceof Clock)) {
            this.renderer.stop();
        }
    }

    public Object getControl(String string) {
        return this.renderer.getControl(string);
    }

    public Object[] getControls() {
        return this.renderer.getControls();
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public long getRTPTime() {
        if (this.ic.getFormat() instanceof AudioFormat) {
            if (this.renderer instanceof AudioRenderer) {
                return this.lastTimeStamp - ((AudioRenderer)this.renderer).getLatency();
            }
            return this.lastTimeStamp;
        }
        return this.lastTimeStamp;
    }

    private long getSyncTime(long l) {
        if (this.rtpTimeBase != null) {
            if (this.rtpTimeBase.getMaster() == this.getController()) {
                return l;
            }
            long l2 = this.rtpTimeBase.getNanoseconds();
            if (l2 > l + 2000000000L || l2 < l - 2000000000L) {
                if (!this.rtpErrMsg) {
                    Log.comment("Cannot perform RTP sync beyond a difference of: " + (l2 - l) / 1000000L + " msecs.\n");
                    this.rtpErrMsg = true;
                }
                return l;
            }
            return l2;
        }
        return this.getMediaNanoseconds();
    }

    private boolean handleFormatChange(Format format) {
        float f;
        if (!this.reinitRenderer(format)) {
            this.storedBuffer = null;
            this.failed = true;
            if (this.moduleListener != null) {
                this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), format);
            }
            return false;
        }
        Format format2 = this.ic.getFormat();
        this.ic.setFormat(format);
        if (this.moduleListener != null) {
            this.moduleListener.formatChanged(this, format2, format);
        }
        if (format instanceof VideoFormat && (f = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f;
        }
        return true;
    }

    protected boolean handlePreroll(Buffer buffer) {
        if (buffer.getFormat() instanceof AudioFormat ? !this.hasReachAudioPrerollTarget(buffer) : (buffer.getFlags() & 0x60) == 0 && buffer.getTimeStamp() >= 0L && buffer.getTimeStamp() < this.getSyncTime(buffer.getTimeStamp())) {
            return false;
        }
        this.prerolling = false;
        return true;
    }

    private boolean hasReachAudioPrerollTarget(Buffer buffer) {
        long l = this.getSyncTime(buffer.getTimeStamp());
        this.elapseTime.update(buffer.getLength(), buffer.getTimeStamp(), buffer.getFormat());
        if (this.elapseTime.value >= l) {
            long l2 = ElapseTime.audioTimeToLen(this.elapseTime.value - l, (AudioFormat)buffer.getFormat());
            int n = buffer.getOffset() + buffer.getLength() - (int)l2;
            if (n >= 0) {
                buffer.setOffset(n);
                buffer.setLength((int)l2);
            }
            this.elapseTime.setValue(l);
            return true;
        }
        return false;
    }

    public boolean isThreaded() {
        return true;
    }

    protected void process() {
    }

    public int processBuffer(Buffer buffer) {
        int n = buffer.getLength();
        int n2 = buffer.getOffset();
        int n3 = 0;
        boolean bl = false;
        if (this.renderer instanceof Clock) {
            this.overflown = (buffer.getFlags() & 0x2000) != 0 ? ++this.overflown : --this.overflown;
            if (this.overflown > 20) {
                if (this.rate < 1.05f) {
                    this.rate += 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                    if (!this.overMsg) {
                        Log.comment("Data buffers overflown.  Adjust rendering speed up to 5 % to compensate");
                        this.overMsg = true;
                    }
                }
                this.overflown = 10;
            } else if (this.overflown <= 0) {
                if (this.rate > 1.0f) {
                    this.rate -= 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                }
                this.overflown = 10;
            }
        }
        do {
            int n4;
            block25: {
                if (this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
                    if (this.prefetching) {
                        this.donePrefetch();
                    }
                    return 2;
                }
                if (n <= this.chunkSize || this.prerolling) {
                    if (bl) {
                        bl = false;
                        buffer.setEOM(true);
                    }
                    n4 = n;
                } else {
                    if (buffer.isEOM()) {
                        bl = true;
                        buffer.setEOM(false);
                    }
                    n4 = this.chunkSize;
                }
                buffer.setLength(n4);
                buffer.setOffset(n2);
                if (this.prerolling && !this.handlePreroll(buffer)) {
                    n2 += n4;
                    n -= n4;
                    continue;
                }
                try {
                    n3 = this.renderer.process(buffer);
                }
                catch (Throwable throwable) {
                    Log.dumpStack(throwable);
                    if (this.moduleListener == null) break block25;
                    this.moduleListener.internalErrorOccurred(this);
                }
            }
            if ((n3 & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                return n3;
            }
            if ((n3 & 1) != 0) {
                buffer.setDiscard(true);
                if (this.prefetching) {
                    this.donePrefetch();
                }
                return n3;
            }
            if ((n3 & 2) != 0) {
                n4 -= buffer.getLength();
            }
            n2 += n4;
            n -= n4;
            if (this.prefetching && (!(this.renderer instanceof Prefetchable) || ((Prefetchable)((Object)this.renderer)).isPrefetched())) {
                bl = false;
                buffer.setEOM(false);
                this.donePrefetch();
                break;
            }
            this.elapseTime.update(n4, buffer.getTimeStamp(), buffer.getFormat());
        } while (n > 0 && !this.resetted);
        if (bl) {
            buffer.setEOM(true);
        }
        buffer.setLength(n);
        buffer.setOffset(n2);
        if (n3 == 0) {
            ++this.framesPlayed;
        }
        return n3;
    }

    protected boolean reinitRenderer(Format format) {
        if (this.renderer != null && this.renderer.setInputFormat(format) != null) {
            return true;
        }
        if (this.started) {
            this.renderer.stop();
            this.renderer.reset();
        }
        this.renderer.close();
        this.renderer = null;
        Renderer renderer = SimpleGraphBuilder.findRenderer(format);
        if (renderer == null) {
            return false;
        }
        this.setRenderer(renderer);
        if (this.started) {
            this.renderer.start();
        }
        this.chunkSize = this.computeChunkSize(format);
        return true;
    }

    public void reset() {
        super.reset();
        this.prefetching = false;
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    protected boolean scheduleBuffer(Buffer buffer) {
        int n = 0;
        Format format = buffer.getFormat();
        if (format == null) {
            format = this.ic.getFormat();
            buffer.setFormat(format);
        }
        if (!(format == this.ic.getFormat() || format.equals(this.ic.getFormat()) || buffer.isDiscard() || this.handleFormatChange(format))) {
            return false;
        }
        if ((buffer.getFlags() & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
        }
        if (this.prefetching || format instanceof AudioFormat || buffer.getTimeStamp() <= 0L || (buffer.getFlags() & 0x60) == 96 || this.noSync) {
            if (!buffer.isDiscard()) {
                n = this.processBuffer(buffer);
            }
        } else {
            long l = this.getSyncTime(buffer.getTimeStamp());
            long l2 = l / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            if (this.storedBuffer == null && l2 > 0L) {
                if (buffer.isDiscard()) {
                    this.notToDropNext = true;
                } else {
                    if (buffer.isEOM()) {
                        this.notToDropNext = true;
                    } else if (this.moduleListener != null && format instanceof VideoFormat) {
                        float f = (float)l2 * this.frameRate / 1000.0f;
                        if (f < 1.0f) {
                            f = 1.0f;
                        }
                        this.moduleListener.framesBehind(this, f, this.ic);
                        this.framesWereBehind = true;
                    }
                    if ((buffer.getFlags() & 0x20) != 0) {
                        n = this.processBuffer(buffer);
                    } else if (l2 < this.LEEWAY || this.notToDropNext || buffer.getTimeStamp() - this.lastRendered > 1000000000L) {
                        n = this.processBuffer(buffer);
                        this.lastRendered = buffer.getTimeStamp();
                        this.notToDropNext = false;
                    }
                }
            } else {
                if (this.moduleListener != null && this.framesWereBehind && format instanceof VideoFormat) {
                    this.moduleListener.framesBehind(this, 0.0f, this.ic);
                    this.framesWereBehind = false;
                }
                if (!buffer.isDiscard()) {
                    if ((buffer.getFlags() & 0x40) == 0) {
                        this.waitForPT(buffer.getTimeStamp());
                    }
                    if (!this.resetted) {
                        n = this.processBuffer(buffer);
                        this.lastRendered = buffer.getTimeStamp();
                    }
                }
            }
        }
        if (n & true) {
            this.storedBuffer = null;
        } else if ((n & 2) != 0) {
            this.storedBuffer = buffer;
        } else {
            this.storedBuffer = null;
            if (buffer.getDuration() >= 0L) {
                this.lastDuration = buffer.getDuration();
            }
        }
        return true;
    }

    public void setFormat(Connector connector, Format format) {
        float f;
        this.renderer.setInputFormat(format);
        if (format instanceof VideoFormat && (f = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = f;
        }
    }

    public void setPreroll(long l, long l2) {
        super.setPreroll(l, l2);
        this.elapseTime.setValue(l2);
    }

    protected void setRenderer(Renderer renderer) {
        this.renderer = renderer;
        if (this.renderer instanceof Clock) {
            this.setClock((Clock)((Object)this.renderer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReset() {
        if (this.renderer != null) {
            this.renderer.reset();
        }
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.renderThread.start();
            }
        }
    }

    private boolean waitForPT(long l) {
        long l2 = this.getSyncTime(l);
        long l3 = -1L;
        int n = 0;
        long l4 = (l - l2) / 1000000L;
        if (this.rate != 1.0f) {
            l4 = (long)((float)l4 / this.rate);
        }
        while (l4 > this.systemErr && !this.resetted) {
            long l5;
            if (l4 == l3) {
                l5 = l4 + (long)(5 * n);
                if (l5 > 33L) {
                    l5 = 33L;
                } else {
                    ++n;
                }
            } else {
                l5 = l4;
                n = 0;
            }
            l5 = l5 > 125L ? 125L : l5;
            long l6 = System.currentTimeMillis();
            l5 -= this.systemErr;
            try {
                if (l5 > 0L) {
                    Thread.sleep(l5);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l7 = System.currentTimeMillis() - l6;
            this.systemErr = (l7 - l5 + this.systemErr) / 2L;
            if (this.systemErr < 0L) {
                this.systemErr = 0L;
            } else if (this.systemErr > l5) {
                this.systemErr = l5;
            }
            l2 = this.getSyncTime(l);
            l3 = l4;
            l4 = (l - l2) / 1000000L;
            if (this.rate != 1.0f) {
                l4 = (long)((float)l4 / this.rate);
            }
            if (this.getState() == 600) continue;
            break;
        }
        return true;
    }
}

