/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtmf;

import java.util.Vector;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.dtmf.DtmfRawPacket;
import org.jitsi.service.neomedia.DTMFRtpTone;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.format.MediaFormat;

public class DtmfTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    private final AudioMediaStreamImpl mediaStream;
    private static final DTMFRtpTone[] supportedTones = new DTMFRtpTone[]{DTMFRtpTone.DTMF_0, DTMFRtpTone.DTMF_1, DTMFRtpTone.DTMF_2, DTMFRtpTone.DTMF_3, DTMFRtpTone.DTMF_4, DTMFRtpTone.DTMF_5, DTMFRtpTone.DTMF_6, DTMFRtpTone.DTMF_7, DTMFRtpTone.DTMF_8, DTMFRtpTone.DTMF_9, DTMFRtpTone.DTMF_A, DTMFRtpTone.DTMF_B, DTMFRtpTone.DTMF_C, DTMFRtpTone.DTMF_D, DTMFRtpTone.DTMF_SHARP, DTMFRtpTone.DTMF_STAR};
    private DTMFDispatcher dtmfDispatcher = null;
    private ToneTransmissionState toneTransmissionState = ToneTransmissionState.IDLE;
    private Vector<DTMFRtpTone> currentTone = new Vector(1, 1);
    private int nbToneToStop = 0;
    private Object startStopToneMutex = new Object();
    private int currentDuration = 0;
    private long currentTimestamp = 0L;
    private int remainingsEndPackets = 0;
    private int currentSpacingDuration = -1;
    private boolean lastMinimalDuration = false;
    private int minimalToneDuration;
    private int maximalToneDuration;
    private int volume;

    public DtmfTransformEngine(AudioMediaStreamImpl stream) {
        this.mediaStream = stream;
    }

    @Override
    public void close() {
    }

    private int getCurrentSpacingDuration() {
        if (this.currentSpacingDuration == -1) {
            MediaType mediaType;
            MediaFormat format = this.mediaStream.getFormat();
            double clockRate = format == null ? (MediaType.VIDEO.equals((Object)(mediaType = this.mediaStream.getMediaType())) ? 90000.0 : -1.0) : format.getClockRate();
            if (clockRate > 0.0) {
                this.currentSpacingDuration = (int)clockRate / 50;
            }
        }
        return this.currentSpacingDuration;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        byte currentDtmfPayload = this.mediaStream.getDynamicRTPPayloadType("telephone-event");
        if (currentDtmfPayload == pkt.getPayloadType()) {
            DtmfRawPacket p = new DtmfRawPacket(pkt);
            if (this.dtmfDispatcher == null) {
                this.dtmfDispatcher = new DTMFDispatcher();
                new Thread(this.dtmfDispatcher).start();
            }
            this.dtmfDispatcher.addTonePacket(p);
            return null;
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.currentTone.isEmpty() || pkt == null || pkt.getVersion() != 2) {
            return pkt;
        }
        byte toneCode = this.currentTone.firstElement().getCode();
        byte currentDtmfPayload = this.mediaStream.getDynamicRTPPayloadType("telephone-event");
        if (currentDtmfPayload == -1) {
            throw new IllegalStateException("Can't send DTMF when no payload type has been negotiated for DTMF events.");
        }
        DtmfRawPacket dtmfPkt = new DtmfRawPacket(pkt.getBuffer(), pkt.getOffset(), pkt.getLength(), currentDtmfPayload);
        long audioPacketTimestamp = dtmfPkt.getTimestamp();
        boolean pktEnd = false;
        boolean pktMarker = false;
        int pktDuration = 0;
        this.checkIfCurrentToneMustBeStopped();
        if (this.toneTransmissionState == ToneTransmissionState.IDLE) {
            this.lastMinimalDuration = false;
            this.currentDuration = 0;
            this.currentDuration += this.getCurrentSpacingDuration();
            pktDuration = this.currentDuration;
            pktMarker = true;
            this.currentTimestamp = audioPacketTimestamp;
            Object object = this.startStopToneMutex;
            synchronized (object) {
                this.toneTransmissionState = ToneTransmissionState.SENDING;
            }
        }
        if (this.toneTransmissionState == ToneTransmissionState.SENDING || this.toneTransmissionState == ToneTransmissionState.END_REQUESTED && !this.lastMinimalDuration) {
            this.currentDuration += this.getCurrentSpacingDuration();
            pktDuration = this.currentDuration;
            if (this.currentDuration > this.minimalToneDuration) {
                this.lastMinimalDuration = true;
            }
            if (this.maximalToneDuration != -1 && this.currentDuration > this.maximalToneDuration) {
                this.toneTransmissionState = ToneTransmissionState.END_REQUESTED;
            }
            if (this.currentDuration > 65535) {
                pktDuration = 65535;
                this.currentDuration = 0;
                this.currentTimestamp = audioPacketTimestamp;
            }
        } else {
            if (this.toneTransmissionState == ToneTransmissionState.END_REQUESTED) {
                this.currentDuration += this.getCurrentSpacingDuration();
                pktDuration = this.currentDuration;
                pktEnd = true;
                this.remainingsEndPackets = 2;
                Object object = this.startStopToneMutex;
                synchronized (object) {
                    this.toneTransmissionState = ToneTransmissionState.END_SEQUENCE_INITIATED;
                }
            }
            if (this.toneTransmissionState == ToneTransmissionState.END_SEQUENCE_INITIATED) {
                pktEnd = true;
                pktDuration = this.currentDuration;
                --this.remainingsEndPackets;
                if (this.remainingsEndPackets == 0) {
                    Object object = this.startStopToneMutex;
                    synchronized (object) {
                        this.toneTransmissionState = ToneTransmissionState.IDLE;
                        this.currentTone.remove(0);
                    }
                }
            }
        }
        dtmfPkt.init(toneCode, pktEnd, pktMarker, pktDuration, this.currentTimestamp, this.volume);
        pkt = dtmfPkt;
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSending(DTMFRtpTone tone, int minimalToneDuration, int maximalToneDuration, int volume) {
        Object object = this.startStopToneMutex;
        synchronized (object) {
            this.stopSendingDTMF();
            this.currentTone.add(tone);
        }
        this.minimalToneDuration = minimalToneDuration * 8;
        this.maximalToneDuration = maximalToneDuration * 8;
        if (maximalToneDuration == -1) {
            this.maximalToneDuration = -1;
        } else if (this.maximalToneDuration < this.minimalToneDuration) {
            this.maximalToneDuration = this.minimalToneDuration;
        }
        this.volume = volume > 0 ? volume : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSendingDTMF() {
        Object object = this.startStopToneMutex;
        synchronized (object) {
            int stoppingTone;
            int n = stoppingTone = this.toneTransmissionState == ToneTransmissionState.END_REQUESTED || this.toneTransmissionState == ToneTransmissionState.END_SEQUENCE_INITIATED ? 1 : 0;
            if (this.currentTone.size() > this.nbToneToStop + stoppingTone) {
                ++this.nbToneToStop;
            }
        }
    }

    public void stop() {
        if (this.dtmfDispatcher != null) {
            this.dtmfDispatcher.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfCurrentToneMustBeStopped() {
        Object object = this.startStopToneMutex;
        synchronized (object) {
            if (this.nbToneToStop > 0 && this.toneTransmissionState == ToneTransmissionState.SENDING) {
                --this.nbToneToStop;
                this.toneTransmissionState = ToneTransmissionState.END_REQUESTED;
            }
        }
    }

    private class DTMFDispatcher
    implements Runnable {
        private boolean isRunning = false;
        private DTMFRtpTone lastReceivedTone = null;
        private DTMFRtpTone lastReportedTone = null;
        private boolean toEnd = false;

        private DTMFDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            DTMFRtpTone temp = null;
            while (this.isRunning) {
                DTMFDispatcher dTMFDispatcher = this;
                synchronized (dTMFDispatcher) {
                    if (this.lastReceivedTone == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    temp = this.lastReceivedTone;
                    this.lastReceivedTone = null;
                }
                if (temp == null || (this.lastReportedTone != null || this.toEnd) && (this.lastReportedTone == null || !this.toEnd) || DtmfTransformEngine.this.mediaStream == null) continue;
                DtmfTransformEngine.this.mediaStream.fireDTMFEvent(temp, this.toEnd);
                this.lastReportedTone = this.toEnd ? null : temp;
                this.toEnd = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTonePacket(DtmfRawPacket p) {
            DTMFDispatcher dTMFDispatcher = this;
            synchronized (dTMFDispatcher) {
                this.lastReceivedTone = this.getToneFromPacket(p);
                this.toEnd = p.isEnd();
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            DTMFDispatcher dTMFDispatcher = this;
            synchronized (dTMFDispatcher) {
                this.lastReceivedTone = null;
                this.isRunning = false;
                this.notifyAll();
            }
        }

        private DTMFRtpTone getToneFromPacket(DtmfRawPacket p) {
            for (int i = 0; i < supportedTones.length; ++i) {
                DTMFRtpTone t = supportedTones[i];
                if (t.getCode() != p.getCode()) continue;
                return t;
            }
            return null;
        }
    }

    private static enum ToneTransmissionState {
        IDLE,
        SENDING,
        END_REQUESTED,
        END_SEQUENCE_INITIATED;

    }
}

