/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import org.jitsi.impl.neomedia.RTPConnectorUDPImpl;
import org.jitsi.impl.neomedia.RTPConnectorUDPInputStream;
import org.jitsi.impl.neomedia.transform.ControlTransformInputStream;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformUDPOutputStream;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;

public class RTPTransformUDPConnector
extends RTPConnectorUDPImpl {
    private static final Logger logger = Logger.getLogger(RTPTransformUDPConnector.class);
    private TransformEngine engine;

    public RTPTransformUDPConnector(StreamConnector connector) {
        super(connector);
    }

    protected RTPConnectorUDPInputStream createControlInputStream() throws IOException {
        ControlTransformInputStream controlInputStream = new ControlTransformInputStream(this.getControlSocket());
        controlInputStream.setTransformer(this.getRTCPTransformer());
        return controlInputStream;
    }

    @Override
    protected TransformUDPOutputStream createControlOutputStream() throws IOException {
        TransformUDPOutputStream controlOutputStream = new TransformUDPOutputStream(this.getControlSocket());
        controlOutputStream.setTransformer(this.getRTCPTransformer());
        return controlOutputStream;
    }

    protected RTPConnectorUDPInputStream createDataInputStream() throws IOException {
        RTPConnectorUDPInputStream dataInputStream = new RTPConnectorUDPInputStream(this.getDataSocket());
        dataInputStream.setTransformer(this.getRTPTransformer());
        return dataInputStream;
    }

    @Override
    protected TransformUDPOutputStream createDataOutputStream() throws IOException {
        TransformUDPOutputStream dataOutputStream = new TransformUDPOutputStream(this.getDataSocket());
        dataOutputStream.setTransformer(this.getRTPTransformer());
        return dataOutputStream;
    }

    public TransformEngine getEngine() {
        return this.engine;
    }

    private PacketTransformer getRTCPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTCPTransformer();
    }

    private PacketTransformer getRTPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTPTransformer();
    }

    public void setEngine(TransformEngine engine) {
        if (this.engine != engine) {
            TransformUDPOutputStream dataOutputStream;
            RTPConnectorUDPInputStream dataInputStream;
            TransformUDPOutputStream controlOutputStream;
            RTPConnectorUDPInputStream controlInputStream;
            this.engine = engine;
            try {
                controlInputStream = (RTPConnectorUDPInputStream)this.getControlInputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                controlInputStream = null;
            }
            if (controlInputStream != null) {
                controlInputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                controlOutputStream = (TransformUDPOutputStream)this.getControlOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                controlOutputStream = null;
            }
            if (controlOutputStream != null) {
                controlOutputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                dataInputStream = (RTPConnectorUDPInputStream)this.getDataInputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                dataInputStream = null;
            }
            if (dataInputStream != null) {
                dataInputStream.setTransformer(this.getRTPTransformer());
            }
            try {
                dataOutputStream = (TransformUDPOutputStream)this.getDataOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                dataOutputStream = null;
            }
            if (dataOutputStream != null) {
                dataOutputStream.setTransformer(this.getRTPTransformer());
            }
        }
    }
}

