/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.util.Logger;

public class NACKPacket
extends RTCPFBPacket {
    private static final Logger logger = Logger.getLogger(NACKPacket.class);
    public static final int FMT = 1;
    private Collection<Integer> lostPackets = null;

    public NACKPacket(RTCPCompoundPacket base) {
        super(base);
    }

    public NACKPacket(long senderSSRC, long sourceSSRC, Collection<Integer> lostPackets) {
        super(1, 205, senderSSRC, sourceSSRC);
        LinkedList<Integer> sorted = new LinkedList<Integer>(lostPackets);
        Collections.sort(sorted);
        LinkedList<byte[]> nackList = new LinkedList<byte[]>();
        int currentPid = -1;
        byte[] currentNack = null;
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int seq = (Integer)iterator.next();
            if (currentPid == -1 || currentPid + 16 <= seq) {
                currentPid = seq;
                currentNack = new byte[]{(byte)((seq & 0xFF00) >> 8), (byte)(seq & 0xFF), 0, 0};
                nackList.add(currentNack);
                continue;
            }
            int diff = seq - currentPid;
            if (diff <= 8) {
                currentNack[3] = (byte)(currentNack[3] | (byte)(1 << diff - 1));
                continue;
            }
            currentNack[2] = (byte)(currentNack[2] | (byte)(1 << diff - 8 - 1));
        }
        this.fci = new byte[nackList.size() * 4];
        for (int i = 0; i < nackList.size(); ++i) {
            System.arraycopy(nackList.get(i), 0, this.fci, i * 4, 4);
        }
        this.lostPackets = sorted;
    }

    public synchronized Collection<Integer> getLostPackets() {
        if (this.lostPackets != null) {
            return this.lostPackets;
        }
        this.lostPackets = new LinkedList<Integer>();
        if (this.fci != null) {
            for (int i = 0; i < this.fci.length / 4; ++i) {
                int j;
                int pid = (0xFF & this.fci[i * 4 + 0]) << 8 | 0xFF & this.fci[i * 4 + 1];
                this.lostPackets.add(pid);
                for (j = 0; j < 8; ++j) {
                    if (0 == (this.fci[i * 4 + 2] & 1 << j)) continue;
                    this.lostPackets.add((pid + 1 + 8 + j) % 65536);
                }
                for (j = 0; j < 8; ++j) {
                    if (0 == (this.fci[i * 4 + 3] & 1 << j)) continue;
                    this.lostPackets.add((pid + 1 + j) % 65536);
                }
            }
        }
        return this.lostPackets;
    }

    private void writeSsrc(DataOutputStream dataOutputStream, long ssrc) throws IOException {
        dataOutputStream.writeByte((byte)(ssrc >> 24));
        dataOutputStream.writeByte((byte)(ssrc >> 16 & 0xFFL));
        dataOutputStream.writeByte((byte)(ssrc >> 8 & 0xFFL));
        dataOutputStream.writeByte((byte)(ssrc & 0xFFL));
    }

    @Override
    public void assemble(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeByte(-127);
        dataoutputstream.writeByte(-51);
        dataoutputstream.writeShort(2 + this.fci.length / 4);
        this.writeSsrc(dataoutputstream, this.senderSSRC);
        this.writeSsrc(dataoutputstream, this.sourceSSRC);
        dataoutputstream.write(this.fci);
    }

    @Override
    public String toString() {
        return "RTCP NACK packet; packet sender: " + this.senderSSRC + "; media sources: " + this.sourceSSRC + "; NACK entries: " + (this.fci == null ? "none" : Integer.valueOf(this.fci.length / 4)) + "; lost packets: " + (this.lostPackets == null ? "none" : Integer.valueOf(this.lostPackets.size()));
    }

    public RawPacket toRawPacket() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.assemble(dataOutputStream);
        byte[] buf = byteArrayOutputStream.toByteArray();
        return new RawPacket(buf, 0, buf.length);
    }
}

