/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.pulseaudio;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.media.Buffer;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.device.PulseAudioSystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.pulseaudio.PA;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.util.Logger;

public class DataSource
extends AbstractPullBufferCaptureDevice {
    private static final Logger logger;
    private static final int BUFFER_IN_TENS_OF_MILLIS = 10;
    private static final boolean DEBUG;
    private static final int FRAGSIZE_IN_TENS_OF_MILLIS = 2;
    private static final boolean SOFTWARE_GAIN;

    protected PulseAudioStream createStream(int streamIndex, FormatControl formatControl) {
        return new PulseAudioStream(formatControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDisconnect() {
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            AbstractBufferStream<?>[] streams = this.streams();
            if (streams != null && streams.length != 0) {
                for (AbstractBufferStream<?> stream : streams) {
                    if (!(stream instanceof PulseAudioStream)) continue;
                    try {
                        ((PulseAudioStream)stream).disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        super.doDisconnect();
    }

    private String getLocatorDev() {
        String locatorDev;
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            locatorDev = null;
        } else {
            locatorDev = locator.getRemainder();
            if (locatorDev != null && locatorDev.length() <= 0) {
                locatorDev = null;
            }
        }
        return locatorDev;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean softwareGain;
        block3: {
            logger = Logger.getLogger(DataSource.class);
            DEBUG = logger.isDebugEnabled();
            softwareGain = true;
            try {
                StringTokenizer st;
                String libraryVersion = PA.get_library_version();
                if (libraryVersion != null && Integer.parseInt((st = new StringTokenizer(libraryVersion, ".")).nextToken()) >= 1 && Integer.parseInt(st.nextToken()) < 0) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
        SOFTWARE_GAIN = softwareGain;
    }

    private class PulseAudioStream
    extends AbstractPullBufferStream<DataSource> {
        private final PulseAudioSystem audioSystem;
        private byte[] buffer;
        private int channels;
        private boolean corked;
        private long cvolume;
        private int fragsize;
        private final GainControl gainControl;
        private float gainControlLevel;
        private int length;
        private int offset;
        private final PA.stream_request_cb_t readCb;
        private long stream;

        public PulseAudioStream(FormatControl formatControl) {
            super(DataSource.this, formatControl);
            this.corked = true;
            this.readCb = new PA.stream_request_cb_t(){

                @Override
                public void callback(long s, int nbytes) {
                    PulseAudioStream.this.readCb(s, nbytes);
                }
            };
            this.audioSystem = PulseAudioSystem.getPulseAudioSystem();
            if (this.audioSystem == null) {
                throw new IllegalStateException("audioSystem");
            }
            MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
            this.gainControl = mediaServiceImpl == null ? null : (GainControl)((Object)mediaServiceImpl.getInputVolumeControl());
        }

        public void connect() throws IOException {
            this.audioSystem.lockMainloop();
            try {
                this.connectWithMainloopLock();
            }
            finally {
                this.audioSystem.unlockMainloop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connectWithMainloopLock() throws IOException {
            if (this.stream != 0L) {
                return;
            }
            AudioFormat format = (AudioFormat)this.getFormat();
            int sampleRate = (int)format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            if (sampleRate == -1 && MediaUtils.MAX_AUDIO_SAMPLE_RATE != -1.0) {
                sampleRate = (int)MediaUtils.MAX_AUDIO_SAMPLE_RATE;
            }
            if (channels == -1) {
                channels = 1;
            }
            if (sampleSizeInBits == -1) {
                sampleSizeInBits = 16;
            }
            long stream = 0L;
            RuntimeException exception = null;
            try {
                stream = this.audioSystem.createStream(sampleRate, channels, this.getClass().getName(), "phone");
                this.channels = channels;
            }
            catch (IllegalStateException ise) {
                exception = ise;
            }
            catch (RuntimeException re) {
                exception = re;
            }
            if (exception != null) {
                IOException ioe = new IOException();
                ioe.initCause(exception);
                throw ioe;
            }
            if (stream == 0L) {
                throw new IOException("stream");
            }
            try {
                int bytesPerTenMillis = sampleRate / 100 * channels * (sampleSizeInBits / 8);
                this.fragsize = 2 * bytesPerTenMillis;
                this.buffer = new byte[10 * bytesPerTenMillis];
                long attr = PA.buffer_attr_new(-1, -1, -1, -1, this.fragsize);
                if (attr == 0L) {
                    throw new IOException("pa_buffer_attr_new");
                }
                try {
                    Runnable stateCallback = new Runnable(){

                        @Override
                        public void run() {
                            PulseAudioStream.this.audioSystem.signalMainloop(false);
                        }
                    };
                    PA.stream_set_state_callback(stream, stateCallback);
                    PA.stream_connect_record(stream, DataSource.this.getLocatorDev(), attr, 8193);
                    try {
                        int state;
                        if (attr != 0L) {
                            PA.buffer_attr_free(attr);
                            attr = 0L;
                        }
                        if ((state = this.audioSystem.waitForStreamState(stream, 2)) != 2) {
                            throw new IOException("stream.state");
                        }
                        PA.stream_set_read_callback(stream, this.readCb);
                        if (!SOFTWARE_GAIN && this.gainControl != null) {
                            this.cvolume = PA.cvolume_new();
                            boolean freeCvolume = true;
                            try {
                                float gainControlLevel = this.gainControl.getLevel();
                                this.setStreamVolume(stream, gainControlLevel);
                                this.gainControlLevel = gainControlLevel;
                                freeCvolume = false;
                            }
                            finally {
                                if (freeCvolume) {
                                    PA.cvolume_free(this.cvolume);
                                    this.cvolume = 0L;
                                }
                            }
                        }
                        this.stream = stream;
                    }
                    finally {
                        if (this.stream == 0L) {
                            PA.stream_disconnect(stream);
                        }
                    }
                }
                finally {
                    if (attr != 0L) {
                        PA.buffer_attr_free(attr);
                    }
                }
            }
            finally {
                if (this.stream == 0L) {
                    PA.stream_unref(stream);
                }
            }
        }

        private void cork(boolean b) throws IOException {
            try {
                PulseAudioSystem.corkStream(this.stream, b);
                this.corked = b;
            }
            finally {
                this.audioSystem.signalMainloop(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() throws IOException {
            block7: {
                this.audioSystem.lockMainloop();
                try {
                    long stream = this.stream;
                    if (stream == 0L) break block7;
                    try {
                        this.stopWithMainloopLock();
                    }
                    finally {
                        long cvolume = this.cvolume;
                        this.cvolume = 0L;
                        this.stream = 0L;
                        this.buffer = null;
                        this.corked = true;
                        this.fragsize = 0;
                        this.length = 0;
                        this.offset = 0;
                        this.audioSystem.signalMainloop(false);
                        if (cvolume != 0L) {
                            PA.cvolume_free(cvolume);
                        }
                        PA.stream_disconnect(stream);
                        PA.stream_unref(stream);
                    }
                }
                finally {
                    this.audioSystem.unlockMainloop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(Buffer buffer) throws IOException {
            this.audioSystem.lockMainloop();
            try {
                if (this.stream == 0L) {
                    throw new IOException("stream");
                }
                byte[] data = AbstractCodec2.validateByteArraySize(buffer, this.fragsize, false);
                int toRead = this.fragsize;
                int offset = 0;
                int length = 0;
                while (toRead > 0 && !this.corked) {
                    if (this.length <= 0) {
                        this.audioSystem.waitMainloop();
                        continue;
                    }
                    int toCopy = toRead < this.length ? toRead : this.length;
                    System.arraycopy(this.buffer, this.offset, data, offset, toCopy);
                    this.offset += toCopy;
                    this.length -= toCopy;
                    if (this.length <= 0) {
                        this.offset = 0;
                        this.length = 0;
                    }
                    toRead -= toCopy;
                    offset += toCopy;
                    length += toCopy;
                }
                buffer.setFlags(128);
                buffer.setLength(length);
                buffer.setOffset(0);
                buffer.setTimeStamp(System.nanoTime());
                if (this.gainControl != null) {
                    if (SOFTWARE_GAIN || this.cvolume == 0L) {
                        if (length > 0) {
                            BasicVolumeControl.applyGain(this.gainControl, data, 0, length);
                        }
                    } else {
                        float gainControlLevel = this.gainControl.getLevel();
                        if (this.gainControlLevel != gainControlLevel) {
                            this.gainControlLevel = gainControlLevel;
                            this.setStreamVolume(this.stream, gainControlLevel);
                        }
                    }
                }
            }
            finally {
                this.audioSystem.unlockMainloop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readCb(long stream, int length) {
            try {
                int peeked;
                if (this.corked) {
                    peeked = 0;
                } else {
                    int offset;
                    if (this.buffer == null || this.buffer.length < length) {
                        this.buffer = new byte[length];
                        this.offset = 0;
                        this.length = 0;
                        offset = 0;
                    } else {
                        offset = this.offset + this.length;
                        if (offset + length > this.buffer.length) {
                            int overflow = this.length + length - this.buffer.length;
                            if (overflow > 0) {
                                if (overflow >= this.length) {
                                    if (DEBUG && logger.isDebugEnabled()) {
                                        logger.debug("Dropping " + this.length + " bytes!");
                                    }
                                    this.offset = 0;
                                    this.length = 0;
                                    offset = 0;
                                } else {
                                    if (DEBUG && logger.isDebugEnabled()) {
                                        logger.debug("Dropping " + overflow + " bytes!");
                                    }
                                    this.offset += overflow;
                                    this.length -= overflow;
                                }
                            }
                            if (this.length > 0) {
                                int i = 0;
                                while (i < this.length) {
                                    this.buffer[i] = this.buffer[this.offset];
                                    ++i;
                                    ++this.offset;
                                }
                                this.offset = 0;
                                offset = this.length;
                            }
                        }
                    }
                    peeked = PA.stream_peek(stream, this.buffer, offset);
                }
                PA.stream_drop(stream);
                this.length += peeked;
            }
            finally {
                this.audioSystem.signalMainloop(false);
            }
        }

        private void setStreamVolume(long stream, float level) {
            int volume = PA.sw_volume_from_linear(level * 2.0f);
            PA.cvolume_set(this.cvolume, this.channels, volume);
            long o = PA.context_set_source_output_volume(this.audioSystem.getContext(), PA.stream_get_index(stream), this.cvolume, null);
            if (o != 0L) {
                PA.operation_unref(o);
            }
        }

        @Override
        public void start() throws IOException {
            this.audioSystem.lockMainloop();
            try {
                if (this.stream == 0L) {
                    this.connectWithMainloopLock();
                }
                this.cork(false);
            }
            finally {
                this.audioSystem.unlockMainloop();
            }
            super.start();
        }

        @Override
        public void stop() throws IOException {
            this.audioSystem.lockMainloop();
            try {
                this.stopWithMainloopLock();
            }
            finally {
                this.audioSystem.unlockMainloop();
            }
        }

        private void stopWithMainloopLock() throws IOException {
            if (this.stream != 0L) {
                this.cork(true);
            }
            super.stop();
        }
    }
}

