/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelCalculator;
import org.jitsi.impl.neomedia.control.ControlsAdapter;

public class AudioLevelEffect2
extends ControlsAdapter
implements Effect {
    private static final boolean COPY_DATA_FROM_INPUT_TO_OUTPUT = true;
    private Format[] supportedAudioFormats;
    private boolean enabled = false;
    private byte rtpHeaderExtensionId = (byte)-1;

    public AudioLevelEffect2() {
        this.supportedAudioFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, 16, -1.0, Format.byteArray)};
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return this.supportedAudioFormats;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        return new Format[]{new AudioFormat("LINEAR", ((AudioFormat)input).getSampleRate(), 16, 1, 0, 1, 16, -1.0, Format.byteArray)};
    }

    @Override
    public Format setInputFormat(Format format) {
        return format instanceof AudioFormat ? (AudioFormat)format : null;
    }

    @Override
    public Format setOutputFormat(Format format) {
        return format instanceof AudioFormat ? (AudioFormat)format : null;
    }

    @Override
    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        byte[] bufferData;
        Object data = outputBuffer.getData();
        int inputBufferLength = inputBuffer.getLength();
        if (data instanceof byte[] && ((byte[])data).length >= inputBufferLength) {
            bufferData = (byte[])data;
        } else {
            bufferData = new byte[inputBufferLength];
            outputBuffer.setData(bufferData);
        }
        outputBuffer.setLength(inputBufferLength);
        outputBuffer.setOffset(0);
        System.arraycopy(inputBuffer.getData(), inputBuffer.getOffset(), bufferData, 0, inputBufferLength);
        outputBuffer.setFormat(inputBuffer.getFormat());
        outputBuffer.setHeader(inputBuffer.getHeader());
        outputBuffer.setSequenceNumber(inputBuffer.getSequenceNumber());
        outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
        outputBuffer.setRtpTimeStamp(inputBuffer.getRtpTimeStamp());
        outputBuffer.setFlags(inputBuffer.getFlags());
        outputBuffer.setDiscard(inputBuffer.isDiscard());
        outputBuffer.setEOM(inputBuffer.isEOM());
        outputBuffer.setDuration(inputBuffer.getDuration());
        data = outputBuffer.getData();
        Buffer.RTPHeaderExtension ext = outputBuffer.getHeaderExtension();
        if (this.enabled && this.rtpHeaderExtensionId != -1 && data instanceof byte[]) {
            byte level = AudioLevelCalculator.calculateAudioLevel((byte[])data, outputBuffer.getOffset(), outputBuffer.getLength());
            if (ext == null) {
                ext = new Buffer.RTPHeaderExtension(this.rtpHeaderExtensionId, new byte[1]);
            }
            ext.id = this.rtpHeaderExtensionId;
            if (ext.value == null || ext.value.length < 1) {
                ext.value = new byte[1];
            }
            ext.value[0] = level;
            outputBuffer.setHeaderExtension(ext);
        } else {
            outputBuffer.setHeaderExtension(null);
        }
        return 0;
    }

    @Override
    public String getName() {
        return "Audio Level Effect2";
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRtpHeaderExtensionId(byte rtpHeaderExtensionId) {
        this.rtpHeaderExtensionId = rtpHeaderExtensionId;
    }
}

