/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.Collection;
import java.util.logging.Logger;
import org.ice4j.ice.Component;
import org.ice4j.ice.harvest.CandidateHarvesterSetElement;
import org.ice4j.ice.harvest.TrickleCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CandidateHarvesterSetTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(CandidateHarvesterSetTask.class.getName());
    private CandidateHarvesterSetElement harvester;
    private Collection<Component> components;
    private final TrickleCallback trickleCallback;

    public CandidateHarvesterSetTask(CandidateHarvesterSetElement harvester, Collection<Component> components, TrickleCallback trickleCallback) {
        this.harvester = harvester;
        this.components = components;
        this.trickleCallback = trickleCallback;
    }

    public CandidateHarvesterSetElement getHarvester() {
        return this.harvester;
    }

    @Override
    public void run() {
        if (this.harvester == null || !this.harvester.isEnabled()) {
            return;
        }
        for (Component component : this.components) {
            try {
                this.harvester.harvest(component, this.trickleCallback);
            }
            catch (Throwable t) {
                logger.info("disabling harvester due to exception: " + t.getLocalizedMessage());
                this.harvester.setEnabled(false);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        this.harvester = null;
    }
}

