/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.log;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.log.Event;
import org.jitsi.videobridge.log.LoggingService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class InfluxDBLoggingService
implements LoggingService {
    public static final String ENABLED_PNAME = "org.jitsi.videobridge.log.INFLUX_DB_ENABLED";
    public static final String URL_BASE_PNAME = "org.jitsi.videobridge.log.INFLUX_URL_BASE";
    public static final String DATABASE_PNAME = "org.jitsi.videobridge.log.INFLUX_DATABASE";
    public static final String USER_PNAME = "org.jitsi.videobridge.log.INFLUX_USER";
    public static final String PASS_PNAME = "org.jitsi.videobridge.log.INFLUX_PASS";
    private static final Logger logger = Logger.getLogger(InfluxDBLoggingService.class);
    private final Executor executor = ExecutorUtils.newCachedThreadPool((boolean)true, (String)InfluxDBLoggingService.class.getName());
    private final URL url;

    InfluxDBLoggingService(ConfigurationService cfg) throws Exception {
        if (cfg == null) {
            throw new NullPointerException("cfg");
        }
        String s = "Required property not set: ";
        String urlBase = cfg.getString(URL_BASE_PNAME, null);
        if (urlBase == null) {
            throw new Exception(s + URL_BASE_PNAME);
        }
        String database = cfg.getString(DATABASE_PNAME, null);
        if (database == null) {
            throw new Exception(s + DATABASE_PNAME);
        }
        String user = cfg.getString(USER_PNAME, null);
        if (user == null) {
            throw new Exception(s + USER_PNAME);
        }
        String pass = cfg.getString(PASS_PNAME, null);
        if (pass == null) {
            throw new Exception(s + PASS_PNAME);
        }
        String urlStr = urlBase + "/db/" + database + "/series?u=" + user + "&p=" + pass;
        this.url = new URL(urlStr);
        logger.info((Object)("Initialized InfluxDBLoggingService for " + urlBase + ", database \"" + database + "\""));
    }

    public void logEvent(Event e) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)e.getName());
        JSONArray columns = new JSONArray();
        JSONArray point = new JSONArray();
        if (e.useLocalTime()) {
            columns.add((Object)"time");
            point.add((Object)System.currentTimeMillis());
        }
        Collections.addAll(columns, e.getColumns());
        Collections.addAll(point, e.getValues());
        jsonObject.put((Object)"columns", (Object)columns);
        JSONArray points = new JSONArray();
        points.add((Object)point);
        jsonObject.put((Object)"points", (Object)points);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        final String jsonString = jsonArray.toJSONString();
        this.executor.execute(new Runnable(){

            public void run() {
                InfluxDBLoggingService.this.sendPost(jsonString);
            }
        });
    }

    private void sendPost(String s) {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/json");
            connection.setDoOutput(true);
            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            outputStream.writeBytes(s);
            outputStream.flush();
            outputStream.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP response code: " + responseCode);
            }
        }
        catch (IOException ioe) {
            logger.info((Object)("Failed to post to influxdb: " + ioe));
        }
    }
}

