/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.agreement;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.cryptozrtp.BasicAgreement;
import org.bouncycastle.cryptozrtp.CipherParameters;
import org.bouncycastle.cryptozrtp.params.ECPrivateKeyParameters;
import org.bouncycastle.cryptozrtp.params.ECPublicKeyParameters;
import org.bouncycastle.mathzrtp.ec.ECPoint;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public BigIntegerCrypto calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECPoint P = pub.getQ().multiply(this.key.getD());
        return P.getX().toBigInteger();
    }

    public void clear() {
        this.key.getD().zeroize();
        this.key = null;
    }
}

