/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.USOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freedesktop.dbus.Message;

public class MessageWriter {
    private OutputStream out;
    private boolean isunix;

    public MessageWriter(OutputStream outputStream) {
        this.out = outputStream;
        this.isunix = false;
        try {
            if (outputStream instanceof USOutputStream) {
                this.isunix = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.isunix) {
            this.out = new BufferedOutputStream(this.out);
        }
    }

    public void writeMessage(Message message) throws IOException {
        if (null == message) {
            return;
        }
        if (null == message.getWireData()) {
            return;
        }
        if (this.isunix) {
            ((USOutputStream)this.out).write(message.getWireData());
        } else {
            for (byte[] byArray : message.getWireData()) {
                if (null == byArray) break;
                this.out.write(byArray);
            }
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

