/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.osgi;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.jitsi.impl.neomedia.transform.csrc.SsrcTransformEngine;
import org.jitsi.impl.neomedia.transform.srtp.SRTPCryptoContext;
import org.jitsi.impl.osgi.framework.OSGiLauncher;
import org.jitsi.util.ConfigUtils;
import org.jitsi.util.StringUtils;
import org.osgi.framework.BundleActivator;

public class OSGi {
    private static final String BUNDLES_FILE = "bundles.txt";
    private static final String[][] BUNDLES = new String[][]{{"net/java/sip/communicator/impl/libjitsi/LibJitsiActivator"}, {"net/java/sip/communicator/util/UtilActivator", "net/java/sip/communicator/impl/fileaccess/FileAccessActivator"}, {"net/java/sip/communicator/impl/configuration/ConfigurationActivator"}, {"net/java/sip/communicator/impl/resources/ResourceManagementActivator"}, {"net/java/sip/communicator/impl/netaddr/NetaddrActivator"}, {"net/java/sip/communicator/impl/packetlogging/PacketLoggingActivator"}, {"net/java/sip/communicator/service/gui/internal/GuiServiceActivator"}, {"net/java/sip/communicator/service/protocol/media/ProtocolMediaActivator"}, {"org/jitsi/videobridge/log/LoggingBundleActivator"}, {"org/jitsi/videobridge/metrics/MetricServiceActivator"}, {"org/jitsi/videobridge/VideobridgeBundleActivator"}, {"org/jitsi/videobridge/rest/RESTBundleActivator", "org/jitsi/videobridge/stats/StatsManagerBundleActivator"}, {"org/jitsi/videobridge/osgi/OSGiBundleActivator"}};
    private static OSGiLauncher launcher;

    private static void setSystemPropertyDefaults() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        String true_ = Boolean.toString(true);
        String false_ = Boolean.toString(false);
        defaults.put("net.java.sip.communicator.CONFIGURATION_FILE_IS_READ_ONLY", true_);
        defaults.put("net.java.sip.communicator.service.media.DISABLE_AUDIO_SUPPORT", true_);
        defaults.put("net.java.sip.communicator.service.media.DISABLE_VIDEO_SUPPORT", true_);
        defaults.put("net.java.sip.communicator.impl.neomedia.video.maxbandwidth", Integer.toString(Integer.MAX_VALUE));
        defaults.put(SsrcTransformEngine.DROP_MUTED_AUDIO_SOURCE_IN_REVERSE_TRANSFORM, true_);
        defaults.put(SRTPCryptoContext.CHECK_REPLAY_PNAME, false_);
        defaults.put("org.ice4j.ice.harvest.DISABLE_LINK_LOCAL_ADDRESSES", true_);
        for (Map.Entry e : defaults.entrySet()) {
            String key = (String)e.getKey();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, (String)e.getValue());
        }
    }

    public static synchronized void start(BundleActivator bundleActivator) {
        if (launcher == null) {
            launcher = new OSGiLauncher(OSGi.getBundles());
        }
        launcher.start(bundleActivator);
    }

    public static synchronized void stop(BundleActivator bundleActivator) {
        if (launcher != null) {
            launcher.stop(bundleActivator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[][] getBundles() {
        File file = ConfigUtils.getAbsoluteFile((String)BUNDLES_FILE, null);
        if (file == null || !file.exists()) {
            return BUNDLES;
        }
        ArrayList<String[]> lines = new ArrayList<String[]>();
        Scanner input = null;
        try {
            try {
                input = new Scanner(file);
                while (input.hasNextLine()) {
                    String line = input.nextLine();
                    if (StringUtils.isNullOrEmpty((String)line)) continue;
                    lines.add(new String[]{line.trim()});
                }
                Object var6_5 = null;
                if (input != null) {
                    input.close();
                }
            }
            catch (FileNotFoundException e) {
                String[][] stringArray = BUNDLES;
                Object var6_6 = null;
                if (input != null) {
                    input.close();
                }
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (input != null) {
                input.close();
            }
            throw throwable;
        }
        String[][] bundles = lines.isEmpty() ? BUNDLES : (String[][])lines.toArray((T[])new String[lines.size()][]);
        return bundles;
    }

    static {
        OSGi.setSystemPropertyDefaults();
    }
}

