/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class BuddyItem
extends AbstractItemObj {
    public static final int MASK_ACTION_POPUP = 1;
    public static final int MASK_ACTION_PLAY_SOUND = 2;
    public static final int MASK_WHEN_ONLINE = 1;
    public static final int MASK_WHEN_UNIDLE = 2;
    public static final int MASK_WHEN_UNAWAY = 4;
    private static final int TYPE_ALIAS = 305;
    private static final int TYPE_COMMENT = 316;
    private static final int TYPE_ALERT_SOUND = 318;
    private static final int TYPE_ALERT_FLAGS = 317;
    private final String sn;
    private final int groupid;
    private final int id;
    private String alias;
    private String comment;
    private int alertActionMask;
    private int alertWhenMask;
    private String alertSound;

    public BuddyItem(SsiItem ssiItem) {
        Writable writable;
        DefensiveTools.checkNull(ssiItem, "item");
        this.sn = ssiItem.getName();
        this.groupid = ssiItem.getParentId();
        this.id = ssiItem.getId();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        this.alias = immutableTlvChain.getString(305);
        this.comment = immutableTlvChain.getString(316);
        this.alertSound = immutableTlvChain.getString(318);
        Tlv tlv = immutableTlvChain.getLastTlv(317);
        if (tlv != null) {
            writable = tlv.getData();
            this.alertActionMask = BinaryTools.getUByte((ByteBlock)writable, 0);
            this.alertWhenMask = BinaryTools.getUByte((ByteBlock)writable, 1);
            if (this.alertActionMask == -1) {
                this.alertActionMask = 0;
            }
            if (this.alertWhenMask == -1) {
                this.alertWhenMask = 0;
            }
        } else {
            this.alertActionMask = 0;
            this.alertWhenMask = 0;
        }
        writable = TlvTools.getMutableCopy(immutableTlvChain);
        writable.removeTlvs(new int[]{305, 316, 318, 317});
        this.addExtraTlvs((TlvChain)writable);
    }

    public BuddyItem(BuddyItem buddyItem) {
        this(buddyItem.sn, buddyItem.groupid, buddyItem.id, buddyItem.alias, buddyItem.comment, buddyItem.alertWhenMask, buddyItem.alertActionMask, buddyItem.alertSound, buddyItem.copyExtraTlvs());
    }

    public BuddyItem(String string, int n, int n2) {
        this(string, n, n2, null, null, 0, 0, null);
    }

    public BuddyItem(String string, int n, int n2, String string2, String string3, int n3, int n4, String string4) {
        this(string, n, n2, string2, string3, n3, n4, string4, null);
    }

    public BuddyItem(String string, int n, int n2, String string2, String string3, int n3, int n4, String string4, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "groupid", 0);
        DefensiveTools.checkRange(n2, "id", 0);
        DefensiveTools.checkRange(n3, "alertWhenMask", 0);
        DefensiveTools.checkRange(n4, "alertActionMask", 0);
        this.sn = string;
        this.groupid = n;
        this.id = n2;
        this.alias = string2;
        this.comment = string3;
        this.alertActionMask = n4;
        this.alertWhenMask = n3;
        this.alertSound = string4;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getGroupId() {
        return this.groupid;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized String getAlias() {
        return this.alias;
    }

    public final synchronized String getBuddyComment() {
        return this.comment;
    }

    public final synchronized int getAlertActionMask() {
        return this.alertActionMask;
    }

    public final synchronized int getAlertWhenMask() {
        return this.alertWhenMask;
    }

    public final synchronized String getAlertSound() {
        return this.alertSound;
    }

    public final synchronized void setAlias(String string) {
        this.alias = string;
    }

    public final synchronized void setComment(String string) {
        this.comment = string;
    }

    public final synchronized void setAlertActionMask(int n) {
        this.alertActionMask = n;
    }

    public final synchronized void setAlertWhenMask(int n) {
        this.alertWhenMask = n;
    }

    public final synchronized void setAlertSound(String string) {
        this.alertSound = string;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.alias != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(305, this.alias));
        }
        if (this.comment != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(316, this.comment));
        }
        if (this.alertActionMask != 0 || this.alertWhenMask != 0) {
            ByteBlock byteBlock = ByteBlock.wrap(new byte[]{BinaryTools.getUByte(this.alertActionMask)[0], BinaryTools.getUByte(this.alertWhenMask)[0]});
            mutableTlvChain.addTlv(new Tlv(317, byteBlock));
        }
        if (this.alertSound != null) {
            mutableTlvChain.addTlv(Tlv.getStringInstance(318, this.alertSound));
        }
        return this.generateItem(this.sn, this.groupid, this.id, 0, mutableTlvChain);
    }

    public synchronized String toString() {
        boolean bl = (this.alertActionMask & 1) != 0;
        boolean bl2 = (this.alertActionMask & 2) != 0;
        boolean bl3 = (this.alertWhenMask & 1) != 0;
        boolean bl4 = (this.alertWhenMask & 2) != 0;
        boolean bl5 = (this.alertWhenMask & 4) != 0;
        return "BuddyItem for " + this.sn + " (buddy 0x" + Integer.toHexString(this.id) + " in group 0x" + Integer.toHexString(this.groupid) + "): alias=" + this.alias + ", comment=\"" + this.comment + "\", alerts: " + (bl ? "[popup alert] " : "") + (bl2 ? "[play " + this.alertSound + "] " : "") + (bl3 ? "[on signon] " : "") + (bl4 ? "[on unidle] " : "") + (bl5 ? "[on unaway] " : "");
    }
}

