/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class SsiDataCheck
extends SsiCommand {
    private final long lastmod;
    private final int itemCount;

    protected SsiDataCheck(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.lastmod = BinaryTools.getUInt(byteBlock, 0);
        this.itemCount = BinaryTools.getUShort(byteBlock, 4);
    }

    public SsiDataCheck(long l, int n) {
        super(5);
        DefensiveTools.checkRange(l, "lastmod", -1);
        DefensiveTools.checkRange(n, "itemCount", -1);
        this.lastmod = l;
        this.itemCount = n;
    }

    public final long getLastModDate() {
        return this.lastmod;
    }

    public final int getItemCount() {
        return this.itemCount;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.lastmod != -1L) {
            BinaryTools.writeUInt(outputStream, this.lastmod);
            if (this.itemCount != -1) {
                BinaryTools.writeUShort(outputStream, this.itemCount);
            }
        }
    }

    public String toString() {
        return "SsiDataCheck: lastmod=" + this.lastmod + ", " + this.itemCount + " items";
    }
}

