/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.ssi.SsiDataCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiRightsCmd;
import net.kano.joscar.snaccmd.ssi.SsiUnchangedCmd;

public class ClientSsiCmdFactory
implements SnacCmdFactory {
    private static final CmdType[] SUPPORTED_TYPES = new CmdType[]{new CmdType(19, 3), new CmdType(19, 6), new CmdType(19, 15), new CmdType(19, 14)};

    public CmdType[] getSupportedTypes() {
        return (CmdType[])SUPPORTED_TYPES.clone();
    }

    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 19) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 3) {
            return new SsiRightsCmd(snacPacket);
        }
        if (n == 6) {
            return new SsiDataCmd(snacPacket);
        }
        if (n == 15) {
            return new SsiUnchangedCmd(snacPacket);
        }
        if (n == 14) {
            return new SsiDataModResponse(snacPacket);
        }
        return null;
    }
}

