/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.loc.DirInfoCmd;
import net.kano.joscar.snaccmd.loc.LocRightsCmd;
import net.kano.joscar.snaccmd.loc.SetDirAck;
import net.kano.joscar.snaccmd.loc.SetInterestsAck;
import net.kano.joscar.snaccmd.loc.UserInfoCmd;

public class ClientLocCmdFactory
implements SnacCmdFactory {
    private static final CmdType[] SUPPORTED_TYPES = new CmdType[]{new CmdType(2, 3), new CmdType(2, 6), new CmdType(2, 12), new CmdType(2, 16), new CmdType(2, 10)};

    public CmdType[] getSupportedTypes() {
        return (CmdType[])SUPPORTED_TYPES.clone();
    }

    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 2) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 3) {
            return new LocRightsCmd(snacPacket);
        }
        if (n == 6) {
            return new UserInfoCmd(snacPacket);
        }
        if (n == 12) {
            return new DirInfoCmd(snacPacket);
        }
        if (n == 16) {
            return new SetInterestsAck(snacPacket);
        }
        if (n == 10) {
            return new SetDirAck(snacPacket);
        }
        return null;
    }
}

