/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.MiniUserInfo;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class WarningNotification
extends ConnCommand {
    private final int level;
    private final MiniUserInfo by;

    protected WarningNotification(SnacPacket snacPacket) {
        super(16);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.level = BinaryTools.getUShort(byteBlock, 0);
        this.by = MiniUserInfo.readUserInfo(byteBlock.subBlock(2));
    }

    public WarningNotification(int n) {
        this(n, null);
    }

    public WarningNotification(int n, MiniUserInfo miniUserInfo) {
        super(16);
        DefensiveTools.checkRange(n, "level", 0);
        this.level = n;
        this.by = miniUserInfo;
    }

    public final int getNewLevel() {
        return this.level;
    }

    public final MiniUserInfo getWarner() {
        return this.by;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.level);
        if (this.by != null) {
            this.by.write(outputStream);
        }
    }

    public String toString() {
        return "WarningNotification: warned to " + this.level + "% by <" + this.by + ">";
    }
}

