/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ServiceRequest
extends ConnCommand {
    private static final int TYPE_ROOM_INFO = 1;
    private final int family;
    private final MiniRoomInfo roomInfo;

    protected ServiceRequest(SnacPacket snacPacket) {
        super(4);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.family = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        Tlv tlv = immutableTlvChain.getLastTlv(1);
        if (tlv != null) {
            ByteBlock byteBlock3 = tlv.getData();
            this.roomInfo = MiniRoomInfo.readMiniRoomInfo(byteBlock3);
        } else {
            this.roomInfo = null;
        }
    }

    public ServiceRequest(int n) {
        this(n, null);
    }

    public ServiceRequest(MiniRoomInfo miniRoomInfo) {
        this(14, miniRoomInfo);
    }

    public ServiceRequest(int n, MiniRoomInfo miniRoomInfo) {
        super(4);
        DefensiveTools.checkRange(n, "snacFamily", 0);
        this.family = n;
        this.roomInfo = miniRoomInfo;
    }

    public final int getRequestedFamily() {
        return this.family;
    }

    public final MiniRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.family);
        if (this.roomInfo != null) {
            ByteBlock byteBlock = ByteBlock.createByteBlock(this.roomInfo);
            new Tlv(1, byteBlock).write(outputStream);
        }
    }

    public String toString() {
        return "ServiceRequest for family 0x" + Integer.toHexString(this.family) + (this.roomInfo == null ? "" : " (chat room: <" + this.roomInfo + ">)");
    }
}

