/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ShortCapabilityBlock;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class FullUserInfo
implements LiveWritable {
    public static final int MASK_UNCONFIRMED = 1;
    public static final int MASK_ADMIN = 2;
    public static final int MASK_AOL = 4;
    public static final int MASK_FREE = 16;
    public static final int MASK_WIRELESS = 128;
    public static final int MASK_AB = 1024;
    public static final int MASK_AWAY = 32;
    public static final long MASK_ALL = 0xFFFFFFFFL;
    private static final int TYPE_USER_FLAG = 1;
    private static final int TYPE_ACCT_CREATED = 2;
    private static final int TYPE_ON_SINCE = 3;
    private static final int TYPE_IDLE_MINS = 4;
    private static final int TYPE_MEMBER_SINCE = 5;
    private static final int TYPE_CAPS = 13;
    private static final int TYPE_SESS_LEN_AIM = 15;
    private static final int TYPE_SESS_LEN_AOL = 16;
    private static final int TYPE_EXTRA_INFO = 29;
    private static final int TYPE_CERT_HASH = 27;
    private static final int TYPE_SHORT_CAPS = 25;
    private final String sn;
    private final int totalSize;
    private final int warningLevel;
    private final int flags;
    private final Date accountCreated;
    private final Date memberSince;
    private final long sessionLengthAIM;
    private final long sessionLengthAOL;
    private final Date onSince;
    private final int idleMins;
    private final CapabilityBlock[] capabilityBlocks;
    private final Boolean away;
    private final ExtraInfoBlock[] extraInfos;
    private final ByteBlock certInfoHash;
    private final ShortCapabilityBlock[] shortCaps;
    private final ImmutableTlvChain extraTlvs;

    public static FullUserInfo readUserInfo(ByteBlock byteBlock) {
        ByteBlock byteBlock2;
        DefensiveTools.checkNull(byteBlock, "block");
        int n = byteBlock.getOffset();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        if (stringBlock == null) {
            return null;
        }
        String string = stringBlock.getString();
        int n2 = stringBlock.getTotalSize();
        if (byteBlock.getLength() < n2 + 2) {
            return new FullUserInfo(string, n2);
        }
        byteBlock = byteBlock.subBlock(n2);
        int n3 = BinaryTools.getUShort(byteBlock, 0);
        if ((byteBlock = byteBlock.subBlock(2)).getLength() < 2) {
            return new FullUserInfo(string, n3, n2 + 2);
        }
        int n4 = BinaryTools.getUShort(byteBlock, 0);
        byteBlock = byteBlock.subBlock(2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock, n4);
        Tlv tlv = immutableTlvChain.getLastTlv(1);
        Tlv tlv2 = immutableTlvChain.getLastTlv(2);
        Tlv tlv3 = immutableTlvChain.getLastTlv(3);
        Tlv tlv4 = immutableTlvChain.getLastTlv(4);
        Tlv tlv5 = immutableTlvChain.getLastTlv(5);
        Tlv tlv6 = immutableTlvChain.getLastTlv(13);
        Tlv tlv7 = immutableTlvChain.getLastTlv(15);
        Tlv tlv8 = immutableTlvChain.getLastTlv(16);
        Tlv tlv9 = immutableTlvChain.getLastTlv(29);
        Tlv tlv10 = immutableTlvChain.getLastTlv(27);
        Tlv tlv11 = immutableTlvChain.getLastTlv(25);
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
        mutableTlvChain.removeTlvs(new int[]{1, 2, 3, 4, 5, 13, 15, 16, 29, 27, 25});
        Boolean bl = null;
        int n5 = -1;
        if (tlv != null) {
            n5 = tlv.getDataAsUShort();
            bl = (n5 & 0x20) != 0;
        }
        Date date = null;
        if (tlv2 != null) {
            date = new Date(tlv2.getDataAsUInt() * 1000L);
        }
        Date date2 = null;
        if (tlv5 != null) {
            date2 = new Date(tlv5.getDataAsUInt() * 1000L);
        }
        long l = -1L;
        if (tlv7 != null) {
            l = tlv7.getDataAsUInt() * 1000L;
        }
        long l2 = -1L;
        if (tlv8 != null) {
            l2 = tlv8.getDataAsUInt() * 1000L;
        }
        Date date3 = null;
        if (tlv3 != null) {
            date3 = new Date(tlv3.getDataAsUInt() * 1000L);
        }
        int n6 = -1;
        if (tlv4 != null) {
            n6 = tlv4.getDataAsUShort();
        }
        CapabilityBlock[] capabilityBlockArray = null;
        if (tlv6 != null) {
            capabilityBlockArray = CapabilityBlock.getCapabilityBlocks(tlv6.getData());
        }
        ExtraInfoBlock[] extraInfoBlockArray = null;
        if (tlv9 != null) {
            byteBlock2 = tlv9.getData();
            extraInfoBlockArray = ExtraInfoBlock.readExtraInfoBlocks(byteBlock2);
        }
        byteBlock2 = null;
        if (tlv10 != null) {
            byteBlock2 = tlv10.getData();
        }
        ShortCapabilityBlock[] shortCapabilityBlockArray = null;
        if (tlv11 != null) {
            ByteBlock byteBlock3 = tlv11.getData();
            shortCapabilityBlockArray = ShortCapabilityBlock.readShortCaps(byteBlock3);
        }
        byteBlock = byteBlock.subBlock(immutableTlvChain.getTotalSize());
        int n7 = byteBlock.getOffset() - n;
        ImmutableTlvChain immutableTlvChain2 = TlvTools.getImmutableCopy(mutableTlvChain);
        return new FullUserInfo(string, n3, n5, date, date2, l, l2, date3, n6, capabilityBlockArray, bl, extraInfoBlockArray, byteBlock2, shortCapabilityBlockArray, immutableTlvChain2, n7);
    }

    private FullUserInfo(String string, int n) {
        this(string, -1, n);
    }

    private FullUserInfo(String string, int n, int n2) {
        this(string, n, -1, null, null, -1L, -1L, null, -1, null, null, null, null, null, null, n2);
    }

    public FullUserInfo(String string, int n, int n2, Date date, Date date2, long l, long l2, Date date3, int n3, CapabilityBlock[] capabilityBlockArray, Boolean bl, ExtraInfoBlock[] extraInfoBlockArray, ByteBlock byteBlock, ShortCapabilityBlock[] shortCapabilityBlockArray) {
        this(string, n, n2, date, date2, l, l2, date3, n3, capabilityBlockArray, bl, extraInfoBlockArray, byteBlock, shortCapabilityBlockArray, null);
    }

    public FullUserInfo(String string, int n, int n2, Date date, Date date2, long l, long l2, Date date3, int n3, CapabilityBlock[] capabilityBlockArray, Boolean bl, ExtraInfoBlock[] extraInfoBlockArray, ByteBlock byteBlock, ShortCapabilityBlock[] shortCapabilityBlockArray, ImmutableTlvChain immutableTlvChain) {
        this(string, n, n2, date, date2, l, l2, date3, n3, capabilityBlockArray, bl, extraInfoBlockArray, byteBlock, shortCapabilityBlockArray, immutableTlvChain, -1);
    }

    private FullUserInfo(String string, int n, int n2, Date date, Date date2, long l, long l2, Date date3, int n3, CapabilityBlock[] capabilityBlockArray, Boolean bl, ExtraInfoBlock[] extraInfoBlockArray, ByteBlock byteBlock, ShortCapabilityBlock[] shortCapabilityBlockArray, ImmutableTlvChain immutableTlvChain, int n4) {
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "warningLevel", 0);
        DefensiveTools.checkRange(l, "sessAIM", -1);
        DefensiveTools.checkRange(l2, "sessAOL", -1);
        DefensiveTools.checkRange(n3, "idleMins", -1);
        DefensiveTools.checkRange(n4, "totalSize", -1);
        capabilityBlockArray = (CapabilityBlock[])DefensiveTools.getNonnullArray(capabilityBlockArray, "caps");
        extraInfoBlockArray = (ExtraInfoBlock[])DefensiveTools.getNonnullArray(extraInfoBlockArray, "extraInfos");
        shortCapabilityBlockArray = (ShortCapabilityBlock[])DefensiveTools.getNonnullArray(shortCapabilityBlockArray, "shortCaps");
        this.sn = string;
        this.warningLevel = n;
        this.flags = n2;
        this.accountCreated = date;
        this.memberSince = date2;
        this.sessionLengthAIM = l;
        this.sessionLengthAOL = l2;
        this.onSince = date3;
        this.idleMins = n3;
        this.capabilityBlocks = capabilityBlockArray;
        this.away = bl;
        this.extraInfos = extraInfoBlockArray;
        this.certInfoHash = byteBlock;
        this.shortCaps = shortCapabilityBlockArray;
        this.extraTlvs = immutableTlvChain;
        this.totalSize = n4;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getWarningLevel() {
        return this.warningLevel;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final Date getAccountCreated() {
        return this.accountCreated;
    }

    public final Date getMemberSince() {
        return this.memberSince;
    }

    public final long getSessionLengthAIM() {
        return this.sessionLengthAIM;
    }

    public final long getSessionLengthAOL() {
        return this.sessionLengthAOL;
    }

    public final Date getOnSince() {
        return this.onSince;
    }

    public final int getIdleMins() {
        return this.idleMins;
    }

    public final CapabilityBlock[] getCapabilityBlocks() {
        return (CapabilityBlock[])(this.capabilityBlocks == null ? null : this.capabilityBlocks.clone());
    }

    public final Boolean getAwayStatus() {
        return this.away;
    }

    public final ExtraInfoBlock[] getExtraInfoBlocks() {
        return (ExtraInfoBlock[])(this.extraInfos == null ? null : this.extraInfos.clone());
    }

    public final ByteBlock getCertInfoHash() {
        return this.certInfoHash;
    }

    public ShortCapabilityBlock[] getShortCapabilityBlocks() {
        return this.shortCaps == null ? null : (ShortCapabilityBlock[])this.shortCaps.clone();
    }

    public final ImmutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        if (this.warningLevel == -1) {
            return;
        }
        BinaryTools.writeUByte(outputStream, this.warningLevel);
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.flags != -1 || this.away != null) {
            int n = this.flags;
            if (this.away != null) {
                n = this.away.booleanValue() ? (n &= 0x20) : (n &= 0xFFFFFFDF);
            }
            mutableTlvChain.addTlv(Tlv.getUShortInstance(1, n));
        }
        if (this.accountCreated != null) {
            long l = this.accountCreated.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(2, l));
        }
        if (this.memberSince != null) {
            long l = this.memberSince.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(5, l));
        }
        if (this.sessionLengthAIM != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(15, this.sessionLengthAIM));
        }
        if (this.sessionLengthAOL != -1L) {
            mutableTlvChain.addTlv(Tlv.getUIntInstance(16, this.sessionLengthAOL));
        }
        if (this.onSince != null) {
            long l = this.onSince.getTime() / 1000L;
            mutableTlvChain.addTlv(Tlv.getUIntInstance(3, l));
        }
        if (this.idleMins != -1) {
            mutableTlvChain.addTlv(Tlv.getUShortInstance(4, this.idleMins));
        }
        if (this.capabilityBlocks != null) {
            mutableTlvChain.addTlv(new Tlv(13, ByteBlock.wrap(CapabilityBlock.convertToBytes(this.capabilityBlocks))));
        }
        if (this.extraInfos != null) {
            mutableTlvChain.addTlv(new Tlv(29, ByteBlock.createByteBlock(this.extraInfos)));
        }
        if (this.certInfoHash != null) {
            mutableTlvChain.addTlv(new Tlv(27, this.certInfoHash));
        }
        if (this.extraTlvs != null) {
            mutableTlvChain.addAll(this.extraTlvs);
        }
        mutableTlvChain.write(outputStream);
    }

    public String toString() {
        return "UserInfo for " + this.sn + (this.warningLevel != 0 ? this.warningLevel / 10 + "%" : "") + ", flags=" + this.flags + (this.accountCreated != null ? ", acctCrtd=" + this.accountCreated : "") + (this.memberSince != null ? ", memberSince=" + this.memberSince : "") + (this.sessionLengthAIM != -1L ? ", sessLen=" + this.sessionLengthAIM / 60L + "min" : "") + (this.sessionLengthAOL != -1L ? ", sessLen=" + this.sessionLengthAOL / 60L + "min" : "") + (this.onSince != null ? ", onSince=" + this.onSince : "") + (this.idleMins > 0 ? ", idleMins=" + this.idleMins : "") + (this.away != false ? ", away" : "") + (this.extraInfos != null ? ", extraInfos=" + Arrays.asList(this.extraInfos) : "") + (this.certInfoHash != null ? ", encInfo=" + this.certInfoHash : "") + (this.extraTlvs != null && this.extraTlvs.getTlvCount() > 0 ? ", extraTlvs=" + Arrays.asList(this.extraTlvs.getTlvs()) : "") + (this.shortCaps != null ? ", shortcaps: " + Arrays.asList(this.shortCaps) : "") + (this.capabilityBlocks != null ? ", longcaps: " + Arrays.asList(this.capabilityBlocks) : "");
    }
}

