/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;

public abstract class SnacCmdFactoryList {
    private Map factories = new HashMap();

    protected final synchronized void register(CmdType cmdType, SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(cmdType, "type");
        if (!Arrays.asList(snacCmdFactory.getSupportedTypes()).contains(cmdType)) {
            return;
        }
        this.factories.put(cmdType, snacCmdFactory);
    }

    protected final synchronized void registerAll(SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(snacCmdFactory, "factory");
        CmdType[] cmdTypeArray = snacCmdFactory.getSupportedTypes();
        for (int i = 0; i < cmdTypeArray.length; ++i) {
            this.factories.put(cmdTypeArray[i], snacCmdFactory);
        }
    }

    protected final synchronized void unregister(CmdType cmdType, SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(cmdType, "type");
        SnacCmdFactory snacCmdFactory2 = (SnacCmdFactory)this.factories.get(cmdType);
        if (snacCmdFactory2 == snacCmdFactory) {
            this.factories.remove(cmdType);
        }
    }

    protected final synchronized void unregisterAll(SnacCmdFactory snacCmdFactory) {
        DefensiveTools.checkNull(snacCmdFactory, "factory");
        Collection collection = this.factories.values();
        while (collection.remove(snacCmdFactory)) {
        }
    }

    protected final synchronized void unregisterAll() {
        this.factories.clear();
    }

    public final synchronized SnacCmdFactory getFactory(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        return (SnacCmdFactory)this.factories.get(cmdType);
    }
}

