/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptReqRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_MODULUS = 1001;
    private static final int TYPE_PUBLICVALUE = 1002;
    private final BigInteger modulus;
    private final BigInteger publicValue;

    public TrillianCryptReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getExtraTlvs();
        Tlv tlv = tlvChain.getLastTlv(1001);
        this.modulus = tlv != null ? TrillianCryptReqRvCmd.getBigIntFromHexBlock(tlv.getData()) : null;
        Tlv tlv2 = tlvChain.getLastTlv(1002);
        this.publicValue = tlv2 != null ? TrillianCryptReqRvCmd.getBigIntFromHexBlock(tlv2.getData()) : null;
    }

    public TrillianCryptReqRvCmd(BigInteger bigInteger, BigInteger bigInteger2) {
        super(0);
        this.modulus = bigInteger;
        this.publicValue = bigInteger2;
    }

    public final BigInteger getModulus() {
        return this.modulus;
    }

    public final BigInteger getPublicValue() {
        return this.publicValue;
    }

    protected void writeExtraTlvs(OutputStream outputStream) throws IOException {
        ByteBlock byteBlock;
        if (this.modulus != null) {
            byteBlock = ByteBlock.wrap(TrillianCryptReqRvCmd.getBigIntHexBlock(this.modulus));
            new Tlv(1001, byteBlock).write(outputStream);
        }
        if (this.publicValue != null) {
            byteBlock = ByteBlock.wrap(TrillianCryptReqRvCmd.getBigIntHexBlock(this.publicValue));
            new Tlv(1002, byteBlock).write(outputStream);
        }
    }

    public String toString() {
        return "TrillianEncryptReqRvCmd: modulus=" + this.modulus + ", public value=" + this.publicValue;
    }
}

