/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractTrillianCryptRvCmd
extends RvCommand {
    public static final int VERSION_DEFAULT = 1;
    public static final int CMDTYPE_REQUEST = 0;
    public static final int CMDTYPE_ACCEPT = 1;
    public static final int CMDTYPE_BEGIN = 2;
    public static final int CMDTYPE_MESSAGE = 3;
    public static final int CMDTYPE_CLOSE = 4;
    private static final int TYPE_VERSION = 999;
    private static final int TYPE_CMDTYPE = 1000;
    private final int version;
    private final int cmdType;
    private final TlvChain extraTlvs;

    public static int getTrillianCmdType(RecvRvIcbm recvRvIcbm) {
        DefensiveTools.checkNull(recvRvIcbm, "icbm");
        ByteBlock byteBlock = recvRvIcbm.getRvData();
        if (byteBlock == null) {
            return -1;
        }
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        return immutableTlvChain.getUShort(1000);
    }

    protected static BigInteger getBigIntFromHexBlock(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        String string = BinaryTools.getNullPadded(byteBlock).getString();
        return new BigInteger(string, 16);
    }

    protected static byte[] getBigIntHexBlock(BigInteger bigInteger) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull(bigInteger, "num");
        byte[] byArray = bigInteger.toString(16).getBytes("US-ASCII");
        if (byArray.length > 32) {
            throw new IllegalArgumentException("number (" + bigInteger + ") is too " + "large to fit into 32 hexadecimal digits");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(33);
        for (int i = byArray.length; i < 32; ++i) {
            byteArrayOutputStream.write(48);
        }
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(0);
        return byteArrayOutputStream.toByteArray();
    }

    protected AbstractTrillianCryptRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(recvRvIcbm.getRvData());
        this.version = immutableTlvChain.getUShort(999);
        this.cmdType = immutableTlvChain.getUShort(1000);
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
        mutableTlvChain.removeTlvs(new int[]{999, 1000});
        this.extraTlvs = mutableTlvChain;
    }

    protected AbstractTrillianCryptRvCmd(int n) {
        this(1, n);
    }

    protected AbstractTrillianCryptRvCmd(int n, int n2) {
        super(0, CapabilityBlock.BLOCK_TRILLIANCRYPT);
        DefensiveTools.checkRange(n, "version", 0);
        DefensiveTools.checkRange(n2, "cmdType", 0);
        this.version = n;
        this.cmdType = n2;
        this.extraTlvs = null;
    }

    protected final int getVersion() {
        return this.version;
    }

    protected final int getCmdType() {
        return this.cmdType;
    }

    protected final TlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    public void writeRvData(OutputStream outputStream) throws IOException {
        Tlv.getUShortInstance(999, this.version).write(outputStream);
        Tlv.getUShortInstance(1000, this.cmdType).write(outputStream);
        this.writeExtraTlvs(outputStream);
    }

    protected abstract void writeExtraTlvs(OutputStream var1) throws IOException;
}

