/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Copydir
extends MatchingTask {
    private File srcDir;
    private File destDir;
    private boolean filtering;
    private boolean flatten;
    private boolean forceOverwrite;
    private Hashtable filecopyList;

    public void setSrc(File file) {
        this.srcDir = file;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public void setForceoverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.log("DEPRECATED - The copydir task is deprecated.  Use copy instead.");
        if (this.srcDir == null) {
            throw new BuildException("src attribute must be set!", this.getLocation());
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir " + this.srcDir.toString() + " does not exist!", this.getLocation());
        }
        if (this.destDir == null) {
            throw new BuildException("The dest attribute must be set.", this.getLocation());
        }
        if (this.srcDir.equals(this.destDir)) {
            this.log("Warning: src == dest", 1);
        }
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        try {
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.scanDir(this.srcDir, this.destDir, stringArray);
            if (this.filecopyList.size() > 0) {
                this.log("Copying " + this.filecopyList.size() + " file" + (this.filecopyList.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
                Enumeration enumeration = this.filecopyList.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this.filecopyList.get(string);
                    try {
                        this.getProject().copyFile(string, string2, this.filtering, this.forceOverwrite);
                    }
                    catch (IOException iOException) {
                        String string3 = "Failed to copy " + string + " to " + string2 + " due to " + iOException.getMessage();
                        throw new BuildException(string3, iOException, this.getLocation());
                    }
                }
            }
            Object var3_10 = null;
            this.filecopyList.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.filecopyList.clear();
            throw throwable;
        }
    }

    private final void scanDir(File file, File file2, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file3 = new File(file, string);
            File file4 = this.flatten ? new File(file2, new File(string).getName()) : new File(file2, string);
            if (this.forceOverwrite || file3.lastModified() > file4.lastModified()) {
                this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
            }
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.filtering = false;
        this.flatten = false;
        this.forceOverwrite = false;
        this.filecopyList = new Hashtable();
    }

    public Copydir() {
        this.this();
    }
}

