/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.RemoteRosterEntry;
import org.jivesoftware.smackx.RosterExchangeListener;
import org.jivesoftware.smackx.packet.RosterExchange;

public class RosterExchangeManager {
    private List<RosterExchangeListener> rosterExchangeListeners = new ArrayList<RosterExchangeListener>();
    private Connection con;
    private PacketFilter packetFilter = new PacketExtensionFilter("x", "jabber:x:roster");
    private PacketListener packetListener;

    public RosterExchangeManager(Connection con) {
        this.con = con;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterListener(RosterExchangeListener rosterExchangeListener) {
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            if (!this.rosterExchangeListeners.contains(rosterExchangeListener)) {
                this.rosterExchangeListeners.add(rosterExchangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRosterListener(RosterExchangeListener rosterExchangeListener) {
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            this.rosterExchangeListeners.remove(rosterExchangeListener);
        }
    }

    public void send(Roster roster, String targetUserID) {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange(roster);
        msg.addExtension(rosterExchange);
        this.con.sendPacket(msg);
    }

    public void send(RosterEntry rosterEntry, String targetUserID) {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange();
        rosterExchange.addRosterEntry(rosterEntry);
        msg.addExtension(rosterExchange);
        this.con.sendPacket(msg);
    }

    public void send(RosterGroup rosterGroup, String targetUserID) {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange();
        for (RosterEntry entry : rosterGroup.getEntries()) {
            rosterExchange.addRosterEntry(entry);
        }
        msg.addExtension(rosterExchange);
        this.con.sendPacket(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterExchangeListeners(String from, Iterator<RemoteRosterEntry> remoteRosterEntries) {
        RosterExchangeListener[] listeners = null;
        List<RosterExchangeListener> list = this.rosterExchangeListeners;
        synchronized (list) {
            listeners = new RosterExchangeListener[this.rosterExchangeListeners.size()];
            this.rosterExchangeListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].entriesReceived(from, remoteRosterEntries);
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                RosterExchange rosterExchange = (RosterExchange)message.getExtension("x", "jabber:x:roster");
                RosterExchangeManager.this.fireRosterExchangeListeners(message.getFrom(), rosterExchange.getRosterEntries());
            }
        };
        this.con.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void destroy() {
        if (this.con != null) {
            this.con.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

