/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

public class Port {
    private Integer port;
    private String hostname;

    public Port(String host, int defaultPort) {
        String[] tokens = host.split(":");
        if (tokens.length == 1) {
            this.port = defaultPort;
        } else if (tokens.length == 2) {
            this.port = new Integer(tokens[1]);
        } else if (tokens.length > 2) {
            throw new IllegalArgumentException("Invalid host string. Too many colons");
        }
        this.hostname = tokens[0];
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getFullHost() {
        return this.hostname + ":" + this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Port other = (Port)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        return !(this.port == null ? other.port != null : !this.port.equals(other.port));
    }

    public String toString() {
        return this.getFullHost();
    }
}

