/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.BlockCipher;

public class SRTPCipherCTR {
    private static final int BLKLEN = 16;
    private static final int MAX_BUFFER_LENGTH = 10240;
    private final byte[] cipherInBlock = new byte[16];
    private final byte[] tmpCipherBlock = new byte[16];
    private byte[] streamBuf = new byte[1024];

    public void process(BlockCipher cipher, byte[] data, int off, int len, byte[] iv) {
        if (off + len > data.length) {
            return;
        }
        byte[] cipherStream = null;
        if (len > this.streamBuf.length) {
            cipherStream = new byte[len];
            if (cipherStream.length <= 10240) {
                this.streamBuf = cipherStream;
            }
        } else {
            cipherStream = this.streamBuf;
        }
        this.getCipherStream(cipher, cipherStream, len, iv);
        for (int i = 0; i < len; ++i) {
            int n = i + off;
            data[n] = (byte)(data[n] ^ cipherStream[i]);
        }
    }

    public void getCipherStream(BlockCipher aesCipher, byte[] out, int length, byte[] iv) {
        int ctr;
        System.arraycopy(iv, 0, this.cipherInBlock, 0, 14);
        for (ctr = 0; ctr < length / 16; ++ctr) {
            this.cipherInBlock[14] = (byte)((ctr & 0xFF00) >> 8);
            this.cipherInBlock[15] = (byte)(ctr & 0xFF);
            aesCipher.processBlock(this.cipherInBlock, 0, out, ctr * 16);
        }
        this.cipherInBlock[14] = (byte)((ctr & 0xFF00) >> 8);
        this.cipherInBlock[15] = (byte)(ctr & 0xFF);
        aesCipher.processBlock(this.cipherInBlock, 0, this.tmpCipherBlock, 0);
        System.arraycopy(this.tmpCipherBlock, 0, out, ctr * 16, length % 16);
    }
}

