/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.imgstreaming;

import java.awt.Component;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import org.jitsi.impl.neomedia.control.ImgStreamingControl;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.imgstreaming.ImageStream;

public class DataSource
extends AbstractVideoPullBufferCaptureDevice {
    private final ImgStreamingControl imgStreamingControl = new ImgStreamingControl(){

        @Override
        public Component getControlComponent() {
            return null;
        }

        @Override
        public void setOrigin(int streamIndex, int displayIndex, int x, int y) {
            DataSource.this.setOrigin(streamIndex, displayIndex, x, y);
        }
    };

    public DataSource() {
    }

    public DataSource(MediaLocator locator) {
        super(locator);
    }

    protected ImageStream createStream(int streamIndex, FormatControl formatControl) {
        int y;
        int x;
        int dispayIndex;
        String remainder = this.getLocator().getRemainder();
        String[] split = remainder.split(",");
        if (split != null && split.length > 1) {
            dispayIndex = Integer.parseInt(split[0]);
            x = Integer.parseInt(split[1]);
            y = Integer.parseInt(split[2]);
        } else {
            dispayIndex = Integer.parseInt(remainder);
            x = 0;
            y = 0;
        }
        ImageStream stream = new ImageStream(this, formatControl);
        stream.setDisplayIndex(dispayIndex);
        stream.setOrigin(x, y);
        return stream;
    }

    @Override
    public Object getControl(String controlType) {
        if (ImgStreamingControl.class.getName().equals(controlType)) {
            return this.imgStreamingControl;
        }
        return super.getControl(controlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrigin(int streamIndex, int displayIndex, int x, int y) {
        Object object = this.getStreamSyncRoot();
        synchronized (object) {
            ImageStream stream;
            AbstractBufferStream<?>[] streams = this.streams();
            if (streams != null && streamIndex < streams.length && (stream = (ImageStream)streams[streamIndex]) != null) {
                stream.setDisplayIndex(displayIndex);
                stream.setOrigin(x, y);
            }
        }
    }
}

