/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.csrc;

import java.util.concurrent.ExecutorService;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.util.ExecutorUtils;

public class CsrcAudioLevelDispatcher
implements Runnable {
    private static final ExecutorService threadPool = ExecutorUtils.newCachedThreadPool(true, "CsrcAudioLevelDispatcher");
    private long[] lastReportedLevels = null;
    private AudioMediaStreamImpl mediaStream;
    private boolean scheduled = false;

    public CsrcAudioLevelDispatcher(AudioMediaStreamImpl mediaStream) {
        this.setMediaStream(mediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLevels(long[] levels) {
        CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
        synchronized (csrcAudioLevelDispatcher) {
            this.lastReportedLevels = levels;
            if (this.mediaStream != null && !this.scheduled) {
                threadPool.execute(this);
                this.scheduled = true;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                long[] levels;
                AudioMediaStreamImpl mediaStream;
                CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
                synchronized (csrcAudioLevelDispatcher) {
                    mediaStream = this.mediaStream;
                    if (mediaStream == null) {
                        this.scheduled = false;
                        break;
                    }
                    if (this.lastReportedLevels == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        continue;
                    }
                    levels = this.lastReportedLevels;
                    this.lastReportedLevels = null;
                }
                if (levels == null) continue;
                mediaStream.audioLevelsReceived(levels);
            }
        }
        finally {
            CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
            synchronized (csrcAudioLevelDispatcher) {
                this.scheduled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaStream(AudioMediaStreamImpl mediaStream) {
        CsrcAudioLevelDispatcher csrcAudioLevelDispatcher = this;
        synchronized (csrcAudioLevelDispatcher) {
            if (this.mediaStream != mediaStream) {
                this.mediaStream = mediaStream;
                this.lastReportedLevels = null;
                this.notifyAll();
            }
        }
    }
}

