/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class PartitionWideEntryBackupOperation
extends AbstractMapOperation
implements BackupOperation,
PartitionAwareOperation {
    EntryBackupProcessor entryProcessor;

    public PartitionWideEntryBackupOperation(String name, EntryBackupProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    public PartitionWideEntryBackupOperation() {
    }

    @Override
    public void run() {
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        Map<Data, Record> records = recordStore.getReadonlyRecordMap();
        for (Map.Entry<Data, Record> recordEntry : records.entrySet()) {
            Data dataKey = recordEntry.getKey();
            Record record = recordEntry.getValue();
            AbstractMap.SimpleEntry<Object, Object> entry = new AbstractMap.SimpleEntry<Object, Object>(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()));
            this.entryProcessor.processBackup(entry);
            if (entry.getValue() == null) {
                recordStore.remove(dataKey);
                continue;
            }
            recordStore.putBackup(dataKey, entry.getValue());
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "PartitionWideEntryBackupOperation{}";
    }
}

