/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.handlers;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.handlers.GGDisconnectingPacketHandler;
import pl.mn.communicator.packet.handlers.GGLoginFailedPacketHandler;
import pl.mn.communicator.packet.handlers.GGLoginOKPacketHandler;
import pl.mn.communicator.packet.handlers.GGMessageReceivedPacketHandler;
import pl.mn.communicator.packet.handlers.GGNotifyReply60PacketHandler;
import pl.mn.communicator.packet.handlers.GGNotifyReplyPacketHandler;
import pl.mn.communicator.packet.handlers.GGPongPacketHandler;
import pl.mn.communicator.packet.handlers.GGPubdirReplyPacketHandler;
import pl.mn.communicator.packet.handlers.GGSentMessageAckPacketHandler;
import pl.mn.communicator.packet.handlers.GGStatus60PacketHandler;
import pl.mn.communicator.packet.handlers.GGStatusPacketHandler;
import pl.mn.communicator.packet.handlers.GGUserListReplyHandler;
import pl.mn.communicator.packet.handlers.GGWelcomePacketHandler;
import pl.mn.communicator.packet.handlers.PacketContext;
import pl.mn.communicator.packet.handlers.PacketHandler;
import pl.mn.communicator.packet.in.GGNeedEmailPacketHandler;

public class PacketChain {
    private static final Log logger = LogFactory.getLog((Class)PacketChain.class);
    private HashMap m_packetHandlers = new HashMap();

    public PacketChain() {
        this.registerDefaultHandlers();
    }

    public void registerGGPackageHandler(int packetType, PacketHandler packetHandler) {
        if (packetHandler == null) {
            throw new NullPointerException("packetHandler cannot be null");
        }
        this.m_packetHandlers.put(new Integer(packetType), packetHandler);
    }

    public void unregisterGGPackageHandler(int packetType) {
        this.m_packetHandlers.remove(new Integer(packetType));
    }

    public void sendToChain(PacketContext packageContent) throws GGException {
        PacketHandler packetHandler = (PacketHandler)this.m_packetHandlers.get(new Integer(packageContent.getHeader().getType()));
        if (packetHandler == null) {
            logger.warn((Object)"Unknown package.");
            logger.warn((Object)("PacketHeader: " + packageContent.getHeader()));
            logger.warn((Object)("PacketBody: " + GGUtils.prettyBytesToString(packageContent.getPackageContent())));
            return;
        }
        packetHandler.handle(packageContent);
    }

    private void registerDefaultHandlers() {
        this.registerGGPackageHandler(1, new GGWelcomePacketHandler());
        this.registerGGPackageHandler(3, new GGLoginOKPacketHandler());
        this.registerGGPackageHandler(9, new GGLoginFailedPacketHandler());
        this.registerGGPackageHandler(20, new GGNeedEmailPacketHandler());
        this.registerGGPackageHandler(2, new GGStatusPacketHandler());
        this.registerGGPackageHandler(15, new GGStatus60PacketHandler());
        this.registerGGPackageHandler(12, new GGNotifyReplyPacketHandler());
        this.registerGGPackageHandler(17, new GGNotifyReply60PacketHandler());
        this.registerGGPackageHandler(10, new GGMessageReceivedPacketHandler());
        this.registerGGPackageHandler(5, new GGSentMessageAckPacketHandler());
        this.registerGGPackageHandler(16, new GGUserListReplyHandler());
        this.registerGGPackageHandler(14, new GGPubdirReplyPacketHandler());
        this.registerGGPackageHandler(11, new GGDisconnectingPacketHandler());
        this.registerGGPackageHandler(7, new GGPongPacketHandler());
    }
}

