/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.addressBook;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openymsg.addressBook.YahooAddressBookEntry;
import org.openymsg.network.Util;
import org.openymsg.roster.Roster;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BuddyListImport {
    private static final Log log = LogFactory.getLog(BuddyListImport.class);
    private Roster roster;
    private String cookieLine;
    private String username;

    public BuddyListImport(String username, Roster roster, String[] sessionCookies) {
        this.username = username;
        this.cookieLine = sessionCookies != null ? "Y=" + sessionCookies[0] + "; " + "T=" + sessionCookies[1] : null;
        this.roster = roster;
    }

    public void process(String userId, String password) throws IOException {
        block8: {
            String addressBookLink = "http://address.yahoo.com/yab/us?v=XM";
            URL u = new URL(addressBookLink);
            URLConnection uc = u.openConnection();
            Util.initURLConnection(uc);
            if (this.cookieLine != null) {
                uc.setRequestProperty("Cookie", this.cookieLine);
            }
            if (uc instanceof HttpURLConnection) {
                int responseCode = ((HttpURLConnection)uc).getResponseCode();
                if (responseCode == 200) {
                    InputStream responseStream = uc.getInputStream();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    ArrayList contacts = new ArrayList();
                    try {
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document dom = db.parse(responseStream);
                        Element docEle = dom.getDocumentElement();
                        log.trace((Object)("user: " + this.username + " Root is: " + docEle));
                        NodeList nl = docEle.getElementsByTagName("ct");
                        log.trace((Object)("user: " + this.username + " Found ct elements: " + nl.getLength()));
                        if (nl != null && nl.getLength() > 0) {
                            for (int i = 0; i < nl.getLength(); ++i) {
                                Element el = (Element)nl.item(i);
                                YahooAddressBookEntry user = this.getContact(el);
                                this.roster.addOrUpdateAddressBook(user);
                            }
                            break block8;
                        }
                        log.debug((Object)("user: " + this.username + " No node list found for ct. AddressBook empty?"));
                    }
                    catch (Exception pce) {
                        log.error((Object)("user: " + this.username + " Failed reading xml addressbook"), (Throwable)pce);
                    }
                } else {
                    log.warn((Object)("user: " + this.username + " responseCode from http is: " + responseCode));
                }
            }
        }
    }

    private YahooAddressBookEntry getContact(Element empEl) {
        String id = this.getTextValue(empEl, "yi");
        String lcsid = this.getTextValue(empEl, "lcsid");
        String firstName = this.getTextValue(empEl, "fn");
        String lastName = this.getTextValue(empEl, "ln");
        String nickName = this.getTextValue(empEl, "nn");
        String groupName = this.getTextValue(empEl, "li");
        if (this.isEmpty(id) && this.isEmpty(lcsid)) {
            log.debug((Object)("user: " + this.username + " Failed building user firstname: " + firstName + ", lastname: " + lastName + ", nickname: " + nickName + ", groupName: " + groupName + ", element: " + empEl + "/" + empEl.getAttributes()));
        }
        if (this.isEmpty(id) && !this.isEmpty(lcsid)) {
            id = lcsid;
        }
        YahooAddressBookEntry user = new YahooAddressBookEntry(id, firstName, lastName, nickName, groupName);
        return user;
    }

    private boolean isEmpty(String id) {
        return id == null || id.length() == 0;
    }

    private String getTextValue(Element ele, String tagName) {
        return ele.getAttribute(tagName);
    }
}

