/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPFeedback;
import net.sf.fmj.media.rtp.RTCPHeader;
import net.sf.fmj.media.rtp.RTPParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RTCPReport
implements Report {
    private String byeReason = "";
    private String cName = null;
    protected Vector<RTCPFeedback> feedbackReports = new Vector();
    protected RTCPHeader header;
    private boolean isBye = false;
    protected Participant participant;
    protected int sdesBytes = 0;
    protected Vector<SourceDescription> sourceDescriptions = new Vector();
    private long ssrc = 0L;
    private long systemTimeStamp;

    public RTCPReport(byte[] data, int offset, int length) throws IOException {
        this.header = new RTCPHeader(data, offset, length);
        if (this.header.getPadding() == 1) {
            throw new IOException("First packet has padding");
        }
        if ((this.header.getLength() + 1) * 4 > length) {
            throw new IOException("Invalid Length");
        }
        this.ssrc = this.header.getSsrc();
        int rtcpReportBlockOffset = 8;
        switch (this.header.getPacketType()) {
            case 200: {
                rtcpReportBlockOffset += 20;
            }
            case 201: {
                this.readFeedbackReports(data, offset + rtcpReportBlockOffset, length - rtcpReportBlockOffset);
                this.readSourceDescription(data, offset += (this.header.getLength() + 1) * 4, length -= (this.header.getLength() + 1) * 4);
                this.readBye(data, offset += this.sdesBytes, length -= this.sdesBytes);
                break;
            }
        }
    }

    public String getByeReason() {
        return this.byeReason;
    }

    public String getCName() {
        return this.cName;
    }

    @Override
    public Vector<RTCPFeedback> getFeedbackReports() {
        return this.feedbackReports;
    }

    @Override
    public Participant getParticipant() {
        return this.participant;
    }

    @Override
    public Vector<SourceDescription> getSourceDescription() {
        return this.sourceDescriptions;
    }

    @Override
    public long getSSRC() {
        return this.ssrc;
    }

    public long getSystemTimeStamp() {
        return this.systemTimeStamp;
    }

    public boolean isByePacket() {
        return this.isBye;
    }

    protected void readBye(byte[] data, int offset, int length) throws IOException {
        RTCPHeader sdesHeader;
        if (length > 0 && (sdesHeader = new RTCPHeader(data, offset, length)).getPacketType() == 203) {
            int reasonLen;
            this.isBye = true;
            if ((sdesHeader.getLength() + 1) * 4 > 8 && (reasonLen = data[offset + 8] & 0xFF) < length - 8 && reasonLen > 0) {
                this.byeReason = new String(data, offset + 8 + 1, reasonLen);
            }
        }
    }

    protected void readFeedbackReports(byte[] data, int offset, int length) throws IOException {
        for (int i = 0; i < this.header.getReceptionCount(); ++i) {
            RTCPFeedback feedback = new RTCPFeedback(data, offset, length);
            this.feedbackReports.add(feedback);
            offset += 24;
        }
    }

    protected void readSourceDescription(byte[] data, int offset, int length) throws IOException {
        RTCPHeader sdesHeader;
        if (length > 0 && (sdesHeader = new RTCPHeader(data, offset, length)).getPacketType() == 202) {
            this.ssrc = sdesHeader.getSsrc();
            this.sdesBytes = (sdesHeader.getLength() + 1) * 4;
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data, offset + 8, length));
            int type = 1;
            while (type != 0) {
                type = stream.readUnsignedByte();
                if (type == 0) continue;
                int len = stream.readUnsignedByte();
                byte[] desc = new byte[len];
                stream.readFully(desc);
                String descStr = new String(desc, "UTF-8");
                SourceDescription description = new SourceDescription(type, descStr, 0, false);
                this.sourceDescriptions.add(description);
                if (type != 1) continue;
                this.cName = descStr;
            }
        }
    }

    protected void setParticipant(RTPParticipant participant) {
        this.participant = participant;
        Vector streams = participant.getStreams();
        if (streams.size() == 0) {
            Vector sdes = participant.getSourceDescription();
            for (int i = 0; i < sdes.size(); ++i) {
                SourceDescription sdesItem = (SourceDescription)sdes.get(i);
                participant.addSourceDescription(sdesItem);
            }
        }
    }

    public void setSystemTimeStamp(long systemTimeStamp) {
        this.systemTimeStamp = systemTimeStamp;
    }
}

