/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.Renderer;

public class GraphNode {
    Class<?> clz;
    public String cname;
    public PlugIn plugin;
    public int type = -1;
    public Format input;
    public Format output = null;
    Format[] supportedIns;
    Format[] supportedOuts;
    public GraphNode prev;
    public int level;
    public boolean failed = false;
    public boolean custom = false;
    static int ARRAY_INC = 30;
    int attemptedIdx = 0;
    Format[] attempted = null;

    public GraphNode(GraphNode graphNode, Format format, GraphNode graphNode2, int n) {
        this.cname = graphNode.cname;
        this.plugin = graphNode.plugin;
        this.type = graphNode.type;
        this.custom = graphNode.custom;
        this.input = format;
        this.prev = graphNode2;
        this.level = n;
        this.supportedIns = graphNode.supportedIns;
        if (graphNode.input == format) {
            this.supportedOuts = graphNode.supportedOuts;
        }
    }

    public GraphNode(PlugIn plugIn, Format format, GraphNode graphNode, int n) {
        this(plugIn == null ? null : plugIn.getClass().getName(), plugIn, format, graphNode, n);
    }

    public GraphNode(String string, PlugIn plugIn, Format format, GraphNode graphNode, int n) {
        this.cname = string;
        this.plugin = plugIn;
        this.input = format;
        this.prev = graphNode;
        this.level = n;
    }

    public boolean checkAttempted(Format format) {
        if (this.attempted == null) {
            this.attempted = new Format[ARRAY_INC];
            this.attempted[this.attemptedIdx++] = format;
            return false;
        }
        for (int i = 0; i < this.attemptedIdx; ++i) {
            if (!format.equals(this.attempted[i])) continue;
            return true;
        }
        if (this.attemptedIdx >= this.attempted.length) {
            Format[] formatArray = new Format[this.attempted.length + ARRAY_INC];
            System.arraycopy(this.attempted, 0, formatArray, 0, this.attempted.length);
            this.attempted = formatArray;
        }
        this.attempted[this.attemptedIdx++] = format;
        return false;
    }

    public Format[] getSupportedInputs() {
        if (this.supportedIns != null) {
            return this.supportedIns;
        }
        if (this.plugin == null) {
            return null;
        }
        if ((this.type == -1 || this.type == 2) && this.plugin instanceof Codec) {
            this.supportedIns = ((Codec)this.plugin).getSupportedInputFormats();
        } else if ((this.type == -1 || this.type == 4) && this.plugin instanceof Renderer) {
            this.supportedIns = ((Renderer)this.plugin).getSupportedInputFormats();
        } else if (this.plugin instanceof Multiplexer) {
            this.supportedIns = ((Multiplexer)this.plugin).getSupportedInputFormats();
        }
        return this.supportedIns;
    }

    public Format[] getSupportedOutputs(Format format) {
        if (format == this.input && this.supportedOuts != null) {
            return this.supportedOuts;
        }
        if (this.plugin == null) {
            return null;
        }
        if ((this.type == -1 || this.type == 4) && this.plugin instanceof Renderer) {
            return null;
        }
        if ((this.type == -1 || this.type == 2) && this.plugin instanceof Codec) {
            Format[] formatArray = ((Codec)this.plugin).getSupportedOutputFormats(format);
            if (this.input == format) {
                this.supportedOuts = formatArray;
            }
            return formatArray;
        }
        return null;
    }

    public void resetAttempted() {
        this.attemptedIdx = 0;
        this.attempted = null;
    }
}

