/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainButtonPanel;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardGainButtonPanel;

public class StandardGainControl
extends AbstractGainControl
implements GainChangeListener {
    public StandardGainControl(Skin skin) {
        super(skin);
    }

    public StandardGainControl(Skin skin, Controller controller) {
        super(skin, controller);
    }

    protected void addControlListener(EventListener eventListener) {
        if (!(eventListener instanceof ActionListener)) {
            throw new IllegalArgumentException("ActionListener required");
        }
        AbstractGainButtonPanel abstractGainButtonPanel = (AbstractGainButtonPanel)this.getControlComponent();
        AbstractButton abstractButton = abstractGainButtonPanel.getGainIncreaseButton();
        abstractButton.addActionListener((ActionListener)eventListener);
        abstractButton = abstractGainButtonPanel.getGainDecreaseButton();
        abstractButton.addActionListener((ActionListener)eventListener);
    }

    protected Component createControlComponent(Skin skin) {
        return new StandardGainButtonPanel(skin);
    }

    protected EventListener createControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractGainButtonPanel abstractGainButtonPanel = (AbstractGainButtonPanel)StandardGainControl.this.getControlComponent();
                GainControl gainControl = StandardGainControl.this.getGainControl();
                float f = gainControl.getLevel();
                if (actionEvent.getSource() == abstractGainButtonPanel.getGainIncreaseButton()) {
                    gainControl.setLevel((f += 0.1f) > 1.0f ? 1.0f : f);
                } else if (actionEvent.getSource() == abstractGainButtonPanel.getGainDecreaseButton()) {
                    gainControl.setLevel((f -= 0.1f) < 0.0f ? 0.0f : f);
                }
            }
        };
    }

    public void gainChange(GainChangeEvent gainChangeEvent) {
        SwingUtilities.invokeLater(new SetStateThread(gainChangeEvent.getLevel()));
    }

    protected void removeControlListener(EventListener eventListener) {
        if (!(eventListener instanceof ActionListener)) {
            throw new IllegalArgumentException("ActionListener required");
        }
        StandardGainButtonPanel standardGainButtonPanel = (StandardGainButtonPanel)this.getControlComponent();
        AbstractButton abstractButton = standardGainButtonPanel.getGainIncreaseButton();
        abstractButton.removeActionListener((ActionListener)eventListener);
        abstractButton = standardGainButtonPanel.getGainDecreaseButton();
        abstractButton.removeActionListener((ActionListener)eventListener);
    }

    public void setComponent(AbstractGainButtonPanel abstractGainButtonPanel) {
        super.setComponent(abstractGainButtonPanel);
    }

    public void setComponentAndListener(AbstractGainButtonPanel abstractGainButtonPanel, ActionListener actionListener) {
        super.setComponentAndListener(abstractGainButtonPanel, actionListener);
    }

    protected void setControllerHook(Controller controller) {
        super.setControllerHook(controller);
        if (this.isOperational()) {
            GainControl gainControl = this.getGainControl();
            this.setState(gainControl.getLevel());
            gainControl.addGainChangeListener(this);
        }
    }

    public void setControlListener(ActionListener actionListener) {
        super.setControlListener(actionListener);
    }

    private void setState(float f) {
        AbstractGainButtonPanel abstractGainButtonPanel = (AbstractGainButtonPanel)this.getControlComponent();
        abstractGainButtonPanel.getGainIncreaseButton().setEnabled(f < 1.0f);
        abstractGainButtonPanel.getGainDecreaseButton().setEnabled(f > 0.0f);
    }

    class SetStateThread
    implements Runnable {
        float level;

        public SetStateThread(float f) {
            this.level = f;
        }

        public void run() {
            StandardGainControl.this.setState(this.level);
        }
    }
}

