/*
 * Decompiled with CFR 0.152.
 */
package javax.media.bean.playerbean;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerListener;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class MediaPlayer
extends Container
implements Player,
Externalizable {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean panelVisible;
    private boolean cachingVisible;
    private boolean looping;
    transient Player player;
    transient Panel panel;
    transient Panel vPanel;
    transient Panel newPanel;
    transient Component visualComponent;
    transient Component controlComponent;
    transient Component cachingComponent;
    private transient int controlPanelHeight;
    private transient int urlFieldHeight;
    protected transient GainControl gainControl;
    protected transient String curVolumeLevel;
    protected transient float curVolumeValue;
    protected transient String curZoomLevel;
    protected transient float curZoomValue;
    protected transient Time mediaTime;
    private boolean displayURL;

    public void addController(Controller controller) throws IncompatibleTimeBaseException {
        if (this.player == null) {
            return;
        }
        this.player.addController(controller);
    }

    public void addControllerListener(ControllerListener controllerListener) {
        if (this.player == null) {
            return;
        }
        this.player.addControllerListener(controllerListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.player == null) {
            return;
        }
        this.player.close();
    }

    public void deallocate() {
        if (this.player == null) {
            return;
        }
        this.player.deallocate();
    }

    public Control getControl(String string) {
        if (this.player == null) {
            return null;
        }
        return this.player.getControl(string);
    }

    public Component getControlPanelComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getControlPanelComponent();
    }

    public int getControlPanelHeight() {
        return this.controlPanelHeight;
    }

    public Control[] getControls() {
        if (this.player == null) {
            return new Control[0];
        }
        return this.player.getControls();
    }

    public Time getDuration() {
        if (this.player == null) {
            return DURATION_UNKNOWN;
        }
        return this.player.getDuration();
    }

    public GainControl getGainControl() {
        if (this.player == null) {
            return null;
        }
        return this.player.getGainControl();
    }

    public String getMediaLocation() {
        if (this.player == null) {
            return " ";
        }
        throw new UnsupportedOperationException();
    }

    public int getMediaLocationHeight() {
        return this.urlFieldHeight;
    }

    protected MediaLocator getMediaLocator(String string) {
        return new MediaLocator("file://" + string);
    }

    public long getMediaNanoseconds() {
        if (this.player == null) {
            return Long.MAX_VALUE;
        }
        return this.player.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getMediaTime();
    }

    public boolean getPlaybackLoop() {
        return this.looping;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Dimension getPreferredSize() {
        throw new UnsupportedOperationException();
    }

    public float getRate() {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.getRate();
    }

    public Time getStartLatency() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getStartLatency();
    }

    public int getState() {
        if (this.player == null) {
            return 100;
        }
        return this.player.getState();
    }

    public Time getStopTime() {
        if (this.player == null) {
            return null;
        }
        return this.player.getStopTime();
    }

    public Time getSyncTime() {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.getSyncTime();
    }

    public int getTargetState() {
        if (this.player == null) {
            return 100;
        }
        return this.player.getTargetState();
    }

    public TimeBase getTimeBase() {
        if (this.player == null) {
            return null;
        }
        return this.player.getTimeBase();
    }

    public Component getVisualComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getVisualComponent();
    }

    public String getVolumeLevel() {
        return this.curVolumeLevel;
    }

    public String getZoomTo() {
        return this.curZoomLevel;
    }

    public boolean isCachingControlVisible() {
        return this.cachingVisible;
    }

    public boolean isControlPanelVisible() {
        return this.panelVisible;
    }

    public boolean isFixedAspectRatio() {
        throw new UnsupportedOperationException();
    }

    public boolean isMediaLocationVisible() {
        return this.displayURL;
    }

    public boolean isPlayBackLoop() {
        return this.looping;
    }

    public Time mapToTimeBase(Time time) throws ClockStoppedException {
        if (this.player == null) {
            return new Time(Long.MAX_VALUE);
        }
        return this.player.mapToTimeBase(time);
    }

    public void prefetch() {
        if (this.player == null) {
            return;
        }
        this.player.prefetch();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void realize() {
        if (this.player == null) {
            return;
        }
        this.player.realize();
    }

    public void removeController(Controller controller) {
        if (this.player == null) {
            return;
        }
        this.player.removeController(controller);
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (this.player == null) {
            return;
        }
        this.player.removeControllerListener(controllerListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void restoreMediaTime() {
        throw new UnsupportedOperationException();
    }

    public void saveMediaTime() {
        throw new UnsupportedOperationException();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException();
    }

    public void setCachingControlVisible(boolean bl) {
        this.cachingVisible = bl;
    }

    public void setCodeBase(URL uRL) {
    }

    public void setControlPanelVisible(boolean bl) {
        this.panelVisible = bl;
    }

    public void setDataSource(DataSource dataSource) {
        try {
            this.player = Manager.createPlayer(dataSource);
        }
        catch (NoPlayerException noPlayerException) {
            logger.log(Level.WARNING, "" + noPlayerException, noPlayerException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    public void setFixedAspectRatio(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setMediaLocation(String string) {
        throw new UnsupportedOperationException();
    }

    public void setMediaLocationVisible(boolean bl) {
        this.displayURL = bl;
    }

    public void setMediaLocator(MediaLocator mediaLocator) {
        try {
            this.player = Manager.createPlayer(mediaLocator);
        }
        catch (NoPlayerException noPlayerException) {
            logger.log(Level.WARNING, "" + noPlayerException, noPlayerException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    public void setMediaTime(Time time) {
        if (this.player == null) {
            return;
        }
        this.player.setMediaTime(time);
    }

    public void setPlaybackLoop(boolean bl) {
        this.looping = bl;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setPopupActive(boolean bl) {
    }

    public float setRate(float f) {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.setRate(f);
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (this.player == null) {
            return;
        }
        this.player.setSource(dataSource);
    }

    public void setStopTime(Time time) {
        if (this.player == null) {
            return;
        }
        this.player.setStopTime(time);
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
        if (this.player == null) {
            return;
        }
        this.player.setTimeBase(timeBase);
    }

    public void setVolumeLevel(String string) {
        this.curVolumeLevel = string;
    }

    public void setZoomTo(String string) {
        this.curZoomLevel = string;
    }

    public void start() {
        if (this.player == null) {
            return;
        }
        this.player.start();
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
    }

    public void stopAndDeallocate() {
        this.stop();
        this.deallocate();
    }

    public void syncStart(Time time) {
        if (this.player == null) {
            return;
        }
        this.player.syncStart(time);
    }

    public synchronized void waitForState(int n) {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        throw new UnsupportedOperationException();
    }
}

