/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import com.t4l.jmf.RGBConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGDecoder
implements Codec {
    private static final Logger logger = LoggerSingleton.logger;
    private static final JPEGFormat jpegFormat = new JPEGFormat();
    private static final RGBFormat rgbFormat = new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1);
    static Hashtable<Dimension, BufferedImage> imageTable = new Hashtable();

    protected static void readJPEG(byte[] byArray, BufferedImage bufferedImage) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        ImageReader imageReader = iterator.next();
        if (imageReader == null) {
            throw new UnsupportedOperationException("This image is unsupported.");
        }
        imageReader.setInput(imageInputStream, false);
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReadParam.setDestination(bufferedImage);
        imageReader.read(0, imageReadParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable<Dimension, BufferedImage> hashtable = imageTable;
        synchronized (hashtable) {
            imageTable.clear();
        }
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new String[0];
    }

    public String getName() {
        return "JPEG Decoder";
    }

    public Format[] getSupportedInputFormats() {
        return new VideoFormat[]{jpegFormat};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new VideoFormat[]{rgbFormat};
        }
        if (format.relax().matches(jpegFormat)) {
            VideoFormat videoFormat = (VideoFormat)format;
            return new VideoFormat[]{new RGBFormat(videoFormat.getSize(), -1, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255)};
        }
        return new Format[0];
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        Format format = buffer.getFormat();
        Format format2 = buffer2.getFormat();
        if (format.relax().matches(jpegFormat) && (format2 == null || format2.relax().matches(rgbFormat))) {
            return this.processJPEGtoRGB(buffer, buffer2);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processJPEGtoRGB(Buffer buffer, Buffer buffer2) {
        Hashtable<Dimension, BufferedImage> hashtable = imageTable;
        synchronized (hashtable) {
            try {
                int[] nArray;
                VideoFormat videoFormat = (VideoFormat)buffer.getFormat();
                RGBFormat rGBFormat = (RGBFormat)buffer2.getFormat();
                if (rGBFormat == null) {
                    int n = videoFormat.getSize().width;
                    int n2 = videoFormat.getSize().height;
                    rGBFormat = new RGBFormat(new Dimension(n, n2), n * n2, Format.intArray, videoFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, n, 0, 1);
                    buffer2.setFormat(rGBFormat);
                }
                byte[] byArray = (byte[])buffer.getData();
                Dimension dimension = videoFormat.getSize();
                BufferedImage bufferedImage = imageTable.get(dimension);
                if (bufferedImage == null) {
                    bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
                }
                JPEGDecoder.readJPEG(byArray, bufferedImage);
                imageTable.put(dimension, bufferedImage);
                Object object = buffer2.getData();
                if (object instanceof int[]) {
                    nArray = (int[])object;
                } else {
                    nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
                    buffer2.setData(nArray);
                }
                RGBConverter.populateArray(bufferedImage, nArray, (RGBFormat)buffer2.getFormat());
                buffer2.setDiscard(buffer.isDiscard());
                buffer2.setDuration(buffer.getDuration());
                buffer2.setEOM(buffer.isEOM());
                buffer2.setFlags(buffer.getFlags());
                buffer2.setHeader(null);
                buffer2.setTimeStamp(buffer.getTimeStamp());
                buffer2.setSequenceNumber(buffer.getSequenceNumber());
                buffer2.setOffset(0);
                buffer2.setLength(bufferedImage.getWidth() * bufferedImage.getHeight());
                return 0;
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "" + throwable, throwable);
                return 1;
            }
        }
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        if (format.relax().matches(jpegFormat)) {
            return format;
        }
        return null;
    }

    public Format setOutputFormat(Format format) {
        if (format.relax().matches(rgbFormat)) {
            return format;
        }
        return null;
    }
}

