/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.jabberconstants;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class JabberStatusEnum {
    private static final Logger logger = Logger.getLogger(JabberStatusEnum.class);
    public static final String AVAILABLE = "Available";
    public static final String AWAY = "Away";
    public static final String DO_NOT_DISTURB = "Do Not Disturb";
    public static final String FREE_FOR_CHAT = "Free For Chat";
    public static final String ON_THE_PHONE = "On the phone";
    public static final String IN_A_MEETING = "In a meeting";
    public static final String EXTENDED_AWAY = "Extended Away";
    public static final String OFFLINE = "Offline";
    public static final String UNKNOWN = "Unknown";
    private final JabberPresenceStatus availableStatus;
    private final JabberPresenceStatus awayStatus;
    private final JabberPresenceStatus doNotDisturbStatus;
    private final JabberPresenceStatus freeForChatStatus;
    private final JabberPresenceStatus offlineStatus;
    private final JabberPresenceStatus onThePhoneStatus;
    private final JabberPresenceStatus inMeetingStatus;
    private final JabberPresenceStatus extendedAwayStatus;
    public final List<PresenceStatus> supportedStatusSet = new LinkedList<PresenceStatus>();
    private final JabberPresenceStatus unknownStatus;
    private static final Map<String, JabberStatusEnum> existingEnums = new Hashtable<String, JabberStatusEnum>();

    public static JabberStatusEnum getJabberStatusEnum(String iconPath) {
        JabberStatusEnum statusEnum = existingEnums.get(iconPath);
        if (statusEnum != null) {
            return statusEnum;
        }
        statusEnum = new JabberStatusEnum(iconPath);
        existingEnums.put(iconPath, statusEnum);
        return statusEnum;
    }

    private JabberStatusEnum(String iconPath) {
        this.offlineStatus = new JabberPresenceStatus(0, OFFLINE, JabberStatusEnum.loadIcon(iconPath + "/status16x16-offline.png"));
        this.doNotDisturbStatus = new JabberPresenceStatus(30, DO_NOT_DISTURB, JabberStatusEnum.loadIcon(iconPath + "/status16x16-dnd.png"));
        this.onThePhoneStatus = new JabberPresenceStatus(31, ON_THE_PHONE, JabberStatusEnum.loadIcon(iconPath + "/status16x16-phone.png"));
        this.inMeetingStatus = new JabberPresenceStatus(32, IN_A_MEETING, JabberStatusEnum.loadIcon(iconPath + "/status16x16-meeting.png"));
        this.extendedAwayStatus = new JabberPresenceStatus(35, EXTENDED_AWAY, JabberStatusEnum.loadIcon(iconPath + "/status16x16-xa.png"));
        this.awayStatus = new JabberPresenceStatus(40, AWAY, JabberStatusEnum.loadIcon(iconPath + "/status16x16-away.png"));
        this.availableStatus = new JabberPresenceStatus(65, AVAILABLE, JabberStatusEnum.loadIcon(iconPath + "/status16x16-online.png"));
        this.freeForChatStatus = new JabberPresenceStatus(85, FREE_FOR_CHAT, JabberStatusEnum.loadIcon(iconPath + "/status16x16-ffc.png"));
        this.unknownStatus = new JabberPresenceStatus(1, UNKNOWN, JabberStatusEnum.loadIcon(iconPath + "/status16x16-offline.png"));
        this.supportedStatusSet.add(this.freeForChatStatus);
        this.supportedStatusSet.add(this.availableStatus);
        this.supportedStatusSet.add(this.awayStatus);
        this.supportedStatusSet.add(this.onThePhoneStatus);
        this.supportedStatusSet.add(this.inMeetingStatus);
        this.supportedStatusSet.add(this.extendedAwayStatus);
        this.supportedStatusSet.add(this.doNotDisturbStatus);
        this.supportedStatusSet.add(this.offlineStatus);
    }

    public JabberPresenceStatus getStatus(String statusName) {
        if (statusName.equals(AVAILABLE)) {
            return this.availableStatus;
        }
        if (statusName.equals(OFFLINE)) {
            return this.offlineStatus;
        }
        if (statusName.equals(FREE_FOR_CHAT)) {
            return this.freeForChatStatus;
        }
        if (statusName.equals(DO_NOT_DISTURB)) {
            return this.doNotDisturbStatus;
        }
        if (statusName.equals(AWAY)) {
            return this.awayStatus;
        }
        if (statusName.equals(ON_THE_PHONE)) {
            return this.onThePhoneStatus;
        }
        if (statusName.equals(IN_A_MEETING)) {
            return this.inMeetingStatus;
        }
        if (statusName.equals(EXTENDED_AWAY)) {
            return this.extendedAwayStatus;
        }
        return this.unknownStatus;
    }

    public Iterator<PresenceStatus> getSupportedStatusSet() {
        return this.supportedStatusSet.iterator();
    }

    public static String[] getStatusNames() {
        return new String[]{OFFLINE, DO_NOT_DISTURB, AWAY, AVAILABLE, FREE_FOR_CHAT};
    }

    public static byte[] loadIcon(String imagePath) {
        return JabberStatusEnum.loadIcon(imagePath, JabberStatusEnum.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadIcon(String imagePath, Class<?> clazz) {
        InputStream is = JabberStatusEnum.getResourceAsStream(imagePath, clazz);
        if (is == null) {
            return null;
        }
        byte[] icon = null;
        try {
            icon = new byte[is.available()];
            is.read(icon);
        }
        catch (IOException exc) {
            logger.error((Object)("Failed to load icon: " + imagePath), (Throwable)exc);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)("Failed to close the InputStream of icon: " + imagePath), (Throwable)ex);
            }
        }
        return icon;
    }

    private static InputStream getResourceAsStream(String name, Class<?> clazz) {
        if (name.indexOf("://") != -1) {
            try {
                return new URL(name).openStream();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        ResourceManagementService resourcesService = ProtocolProviderActivator.getResourceService();
        return resourcesService.getImageInputStreamForPath(name);
    }

    private static class JabberPresenceStatus
    extends PresenceStatus {
        private JabberPresenceStatus(int status, String statusName, byte[] statusIcon) {
            super(status, statusName, statusIcon);
        }
    }
}

