/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.HashSet;
import java.util.Set;

public class ConferenceDescription {
    private String uri;
    private String subject;
    private String callId;
    private String password;
    private String displayName;
    private boolean available = true;
    private Set<String> transports = new HashSet<String>();

    public ConferenceDescription(String uri, String callId, String password) {
        this.uri = uri;
        this.callId = callId;
        this.password = password;
    }

    public ConferenceDescription(String uri, String callId) {
        this(uri, callId, null);
    }

    public ConferenceDescription(String uri) {
        this(uri, null, null);
    }

    public ConferenceDescription() {
        this(null, null, null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void addTransport(String transport) {
        this.transports.add(transport);
    }

    public boolean supportsTransport(String transport) {
        if (this.transports.isEmpty()) {
            return true;
        }
        return this.transports.contains(transport);
    }

    public Set<String> getSupportedTransports() {
        return new HashSet<String>(this.transports);
    }

    public String toString() {
        return "ConferenceDescription(uri=" + this.uri + "; callid=" + this.callId + ")";
    }

    public boolean compareConferenceDescription(ConferenceDescription cd) {
        return this.getCallId().equals(cd.getCallId()) && this.getUri().equals(cd.getUri()) && this.getSupportedTransports().equals(cd.getSupportedTransports());
    }
}

