/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antclipse;

import java.io.File;
import net.sf.antcontrib.antclipse.ClassPathParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassPathTask
extends Task {
    private String project;
    private String idContainer = "antclipse";
    private boolean includeSource = false;
    private boolean includeOutput = false;
    private boolean includeLibs = true;
    private boolean verbose = false;
    RegexpPatternMapper irpm = null;
    RegexpPatternMapper erpm = null;
    public static final String TARGET_CLASSPATH = "classpath";
    public static final String TARGET_FILESET = "fileset";
    private String produce = null;

    public void setIncludeLibs(boolean bl) {
        this.includeLibs = bl;
    }

    public void setproduce(String string) {
        this.produce = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setExcludes(String string) {
        if (string != null) {
            this.erpm = new RegexpPatternMapper();
            this.erpm.setFrom(string);
            this.erpm.setTo(".");
        } else {
            this.erpm = null;
        }
    }

    public void setIncludes(String string) {
        if (string != null) {
            this.irpm = new RegexpPatternMapper();
            this.irpm.setFrom(string);
            this.irpm.setTo(".");
        } else {
            this.irpm = null;
        }
    }

    public void setIdContainer(String string) {
        this.idContainer = string;
    }

    public void setIncludeOutput(boolean bl) {
        this.includeOutput = bl;
    }

    public void setIncludeSource(boolean bl) {
        this.includeSource = bl;
    }

    public void setProject(String string) {
        this.project = string;
    }

    public void execute() throws BuildException {
        AbstractCustomHandler abstractCustomHandler;
        if (!TARGET_CLASSPATH.equalsIgnoreCase(this.produce) && !TARGET_FILESET.equals(this.produce)) {
            throw new BuildException("Mandatory target must be either 'classpath' or 'fileset'");
        }
        ClassPathParser classPathParser = new ClassPathParser();
        if (TARGET_CLASSPATH.equalsIgnoreCase(this.produce)) {
            Path path = new Path(this.getProject());
            this.getProject().addReference(this.idContainer, (Object)path);
            abstractCustomHandler = new PathCustomHandler(path);
        } else {
            FileSet fileSet = new FileSet();
            this.getProject().addReference(this.idContainer, (Object)fileSet);
            fileSet.setDir(new File(this.getProject().getBaseDir().getAbsolutePath().toString()));
            abstractCustomHandler = new FileSetCustomHandler(fileSet);
        }
        classPathParser.parse(new File(this.getProject().getBaseDir().getAbsolutePath(), ".classpath"), abstractCustomHandler);
    }

    class PathCustomHandler
    extends AbstractCustomHandler {
        private Path path = null;

        public PathCustomHandler(Path path) {
            this.path = path;
        }

        private PathCustomHandler() {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (string.equalsIgnoreCase("classpathentry")) {
                String[] stringArray;
                String[] stringArray2;
                String string2 = attributeList.getValue("kind");
                if (string2 == null) {
                    throw new BuildException("classpathentry 'kind' attribute is mandatory");
                }
                String string3 = attributeList.getValue("path");
                if (string3 == null) {
                    throw new BuildException("classpathentry 'path' attribute is mandatory");
                }
                if (string2.equalsIgnoreCase("output")) {
                    stringArray2 = ClassPathTask.this.idContainer + "outpath";
                    stringArray = new Property();
                    stringArray.setName((String)stringArray2);
                    stringArray.setValue(string3);
                    stringArray.setProject(ClassPathTask.this.getProject());
                    stringArray.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + (String)stringArray2 + " to value " + string3);
                    }
                }
                if (string2.equalsIgnoreCase("src")) {
                    stringArray2 = ClassPathTask.this.idContainer + "srcpath";
                    stringArray = new Property();
                    stringArray.setName((String)stringArray2);
                    stringArray.setValue(string3);
                    stringArray.setProject(ClassPathTask.this.getProject());
                    stringArray.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + (String)stringArray2 + " to value " + string3);
                    }
                }
                if (string2.equalsIgnoreCase("src") && ClassPathTask.this.includeSource || string2.equalsIgnoreCase("output") && ClassPathTask.this.includeOutput || string2.equalsIgnoreCase("lib") && ClassPathTask.this.includeLibs) {
                    stringArray2 = new String[]{"all included"};
                    if (ClassPathTask.this.irpm != null) {
                        stringArray2 = ClassPathTask.this.irpm.mapFileName(string3);
                    }
                    stringArray = null;
                    if (ClassPathTask.this.erpm != null) {
                        stringArray = ClassPathTask.this.erpm.mapFileName(string3);
                    }
                    if (stringArray2 != null && stringArray == null) {
                        if (ClassPathTask.this.verbose) {
                            System.out.println("Adding  " + string3 + " to classpath " + ClassPathTask.this.idContainer);
                        }
                        Path.PathElement pathElement = this.path.createPathElement();
                        pathElement.setLocation(new File(string3));
                    }
                }
            }
        }
    }

    class FileSetCustomHandler
    extends AbstractCustomHandler {
        private FileSet fileSet = null;

        private FileSetCustomHandler() {
        }

        public FileSetCustomHandler(FileSet fileSet) {
            this.fileSet = fileSet;
            this.projDir = ClassPathTask.this.getProject().getBaseDir().getAbsolutePath().toString();
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.fileSet != null && !this.fileSet.hasPatterns()) {
                this.fileSet.setExcludes("**/*");
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (string.equalsIgnoreCase("classpathentry")) {
                String[] stringArray;
                String[] stringArray2;
                String string2 = attributeList.getValue("kind");
                if (string2 == null) {
                    throw new BuildException("classpathentry 'kind' attribute is mandatory");
                }
                String string3 = attributeList.getValue("path");
                if (string3 == null) {
                    throw new BuildException("classpathentry 'path' attribute is mandatory");
                }
                if (string2.equalsIgnoreCase("output")) {
                    stringArray2 = ClassPathTask.this.idContainer + "outpath";
                    stringArray = new Property();
                    stringArray.setName((String)stringArray2);
                    stringArray.setValue(string3);
                    stringArray.setProject(ClassPathTask.this.getProject());
                    stringArray.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + (String)stringArray2 + " to value " + string3);
                    }
                }
                if (string2.equalsIgnoreCase("src")) {
                    stringArray2 = ClassPathTask.this.idContainer + "srcpath";
                    stringArray = new Property();
                    stringArray.setName((String)stringArray2);
                    stringArray.setValue(string3);
                    stringArray.setProject(ClassPathTask.this.getProject());
                    stringArray.execute();
                    if (ClassPathTask.this.verbose) {
                        System.out.println("Setting property " + (String)stringArray2 + " to value " + string3);
                    }
                }
                if (string2.equalsIgnoreCase("src") && ClassPathTask.this.includeSource || string2.equalsIgnoreCase("output") && ClassPathTask.this.includeOutput || string2.equalsIgnoreCase("lib") && ClassPathTask.this.includeLibs) {
                    stringArray2 = new String[]{"all included"};
                    if (ClassPathTask.this.irpm != null) {
                        stringArray2 = ClassPathTask.this.irpm.mapFileName(string3);
                    }
                    stringArray = null;
                    if (ClassPathTask.this.erpm != null) {
                        stringArray = ClassPathTask.this.erpm.mapFileName(string3);
                    }
                    if (stringArray2 != null && stringArray == null) {
                        if (string2.equalsIgnoreCase("output")) {
                            FileSet fileSet = new FileSet();
                            String string4 = ClassPathTask.this.idContainer + "-" + string3.replace(File.separatorChar, '-');
                            ClassPathTask.this.getProject().addReference(string4, (Object)fileSet);
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Created new fileset " + string4 + " containing all the files from the output dir " + this.projDir + File.separator + string3);
                            }
                            fileSet.setDefaultexcludes(false);
                            fileSet.setDir(new File(this.projDir + File.separator + string3));
                            fileSet.setIncludes("**/*");
                        } else if (string2.equalsIgnoreCase("src")) {
                            FileSet fileSet = new FileSet();
                            String string5 = ClassPathTask.this.idContainer + "-" + string3.replace(File.separatorChar, '-');
                            ClassPathTask.this.getProject().addReference(string5, (Object)fileSet);
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Created new fileset " + string5 + " containing all the files from the source dir " + this.projDir + File.separator + string3);
                            }
                            fileSet.setDefaultexcludes(false);
                            fileSet.setDir(new File(this.projDir + File.separator + string3));
                            fileSet.setIncludes("**/*");
                        } else {
                            File file = new File(this.fileSet.getDir(ClassPathTask.this.getProject()) + "/" + string3);
                            if (file.isDirectory()) {
                                string3 = string3 + "/**/*";
                            }
                            if (ClassPathTask.this.verbose) {
                                System.out.println("Adding  " + string3 + " to fileset " + ClassPathTask.this.idContainer + " at " + this.fileSet.getDir(ClassPathTask.this.getProject()));
                            }
                            this.fileSet.setIncludes(string3);
                        }
                    }
                }
            }
        }
    }

    abstract class AbstractCustomHandler
    extends HandlerBase {
        protected String projDir;
        protected static final String ATTRNAME_PATH = "path";
        protected static final String ATTRNAME_KIND = "kind";
        protected static final String ATTR_LIB = "lib";
        protected static final String ATTR_SRC = "src";
        protected static final String ATTR_OUTPUT = "output";
        protected static final String EMPTY = "";

        AbstractCustomHandler() {
        }
    }
}

