/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.stringprep.IDNA;
import org.jivesoftware.stringprep.Stringprep;
import org.jivesoftware.stringprep.StringprepException;
import org.jivesoftware.util.cache.ExternalizableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JID
implements Comparable<JID>,
Externalizable {
    private static Cache<String> stringprepCache = new Cache(10000);
    private String node;
    private String domain;
    private String resource;
    private String cachedFullJID;
    private String cachedBareJID;

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int i = 0;
        int n = node.length();
        while (i < n) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    break;
                }
                case '&': {
                    buf.append("\\26");
                    break;
                }
                case '\'': {
                    buf.append("\\27");
                    break;
                }
                case '/': {
                    buf.append("\\2f");
                    break;
                }
                case ':': {
                    buf.append("\\3a");
                    break;
                }
                case '<': {
                    buf.append("\\3c");
                    break;
                }
                case '>': {
                    buf.append("\\3e");
                    break;
                }
                case '@': {
                    buf.append("\\40");
                    break;
                }
                case '\\': {
                    buf.append("\\5c");
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        break;
                    }
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        nodeChars = node.toCharArray();
        buf = new StringBuilder(nodeChars.length);
        i = 0;
        n = nodeChars.length;
        while (i < n) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            c = node.charAt(i);
                            if (c != '\\' || i + 2 >= n) ** GOTO lbl-1000
                            c2 = nodeChars[i + 1];
                            c3 = nodeChars[i + 2];
                            if (c2 != '2') break block16;
                            switch (c3) {
                                case '0': {
                                    buf.append(' ');
                                    i += 2;
                                    break block17;
                                }
                                case '2': {
                                    buf.append('\"');
                                    i += 2;
                                    break block17;
                                }
                                case '6': {
                                    buf.append('&');
                                    i += 2;
                                    break block17;
                                }
                                case '7': {
                                    buf.append('\'');
                                    i += 2;
                                    break block17;
                                }
                                case 'f': {
                                    buf.append('/');
                                    i += 2;
                                    break block17;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        if (c2 != '3') break block18;
                        switch (c3) {
                            case 'a': {
                                buf.append(':');
                                i += 2;
                                break block17;
                            }
                            case 'c': {
                                buf.append('<');
                                i += 2;
                                break block17;
                            }
                            case 'e': {
                                buf.append('>');
                                i += 2;
                                break block17;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    if (c2 != '4') break block19;
                    if (c3 != '0') ** GOTO lbl-1000
                    buf.append("@");
                    i += 2;
                    break block17;
                }
                if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                } else lbl-1000:
                // 5 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String resourceprep(String resource) throws StringprepException {
        String answer = resource;
        if (!stringprepCache.contains(resource)) {
            answer = Stringprep.resourceprep((String)resource);
            if (answer != null && answer.length() * 2 > 1023) {
                return answer;
            }
            stringprepCache.put(answer);
        }
        return answer;
    }

    public JID() {
    }

    public JID(String jid) {
        if (jid == null) {
            throw new NullPointerException("JID cannot be null");
        }
        String[] parts = JID.getParts(jid);
        this.init(parts[0], parts[1], parts[2]);
    }

    public JID(String node, String domain, String resource) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        this.init(node, domain, resource);
    }

    public JID(String node, String domain, String resource, boolean skipStringprep) {
        if (domain == null) {
            throw new NullPointerException("Domain cannot be null");
        }
        if (skipStringprep) {
            this.node = node;
            this.domain = domain;
            this.resource = resource;
            this.updateCache();
        } else {
            this.init(node, domain, resource);
        }
    }

    static String[] getParts(String jid) {
        String[] parts = new String[3];
        String node = null;
        if (jid == null) {
            return parts;
        }
        int atIndex = jid.indexOf("@");
        int slashIndex = jid.indexOf("/");
        if (atIndex > 0) {
            node = jid.substring(0, atIndex);
        }
        if (atIndex + 1 > jid.length()) {
            throw new IllegalArgumentException("JID with empty domain not valid");
        }
        String domain = atIndex < 0 ? (slashIndex > 0 ? jid.substring(0, slashIndex) : jid) : (slashIndex > 0 ? jid.substring(atIndex + 1, slashIndex) : jid.substring(atIndex + 1));
        String resource = slashIndex + 1 > jid.length() || slashIndex < 0 ? null : jid.substring(slashIndex + 1);
        parts[0] = node;
        parts[1] = domain;
        parts[2] = resource;
        return parts;
    }

    private void init(String node, String domain, String resource) {
        if (node != null && node.equals("")) {
            node = null;
        }
        if (resource != null && resource.equals("")) {
            resource = null;
        }
        try {
            if (!stringprepCache.contains(node)) {
                this.node = Stringprep.nodeprep((String)node);
                if (this.node != null && this.node.length() * 2 > 1023) {
                    throw new IllegalArgumentException("Node cannot be larger than 1023 bytes. Size is " + this.node.length() * 2 + " bytes.");
                }
                stringprepCache.put(this.node);
            } else {
                this.node = node;
            }
            if (!stringprepCache.contains(domain)) {
                this.domain = Stringprep.nameprep((String)IDNA.toASCII((String)domain), (boolean)false);
                if (this.domain.length() * 2 > 1023) {
                    throw new IllegalArgumentException("Domain cannot be larger than 1023 bytes. Size is " + this.domain.length() * 2 + " bytes.");
                }
                stringprepCache.put(this.domain);
            } else {
                this.domain = domain;
            }
            this.resource = JID.resourceprep(resource);
            if (resource != null && resource.length() * 2 > 1023) {
                throw new IllegalArgumentException("Resource cannot be larger than 1023 bytes. Size is " + resource.length() * 2 + " bytes.");
            }
            this.updateCache();
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            if (node != null) {
                buf.append(node).append("@");
            }
            buf.append(domain);
            if (resource != null) {
                buf.append("/").append(resource);
            }
            throw new IllegalArgumentException("Illegal JID: " + buf.toString(), e);
        }
    }

    private void updateCache() {
        StringBuilder buf = new StringBuilder(40);
        if (this.node != null) {
            buf.append(this.node).append("@");
        }
        buf.append(this.domain);
        this.cachedBareJID = buf.toString();
        if (this.resource != null) {
            buf.append("/").append(this.resource);
            this.cachedFullJID = buf.toString();
        } else {
            this.cachedFullJID = this.cachedBareJID;
        }
    }

    public String getNode() {
        return this.node;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toBareJID() {
        return this.cachedBareJID;
    }

    public String toString() {
        return this.cachedFullJID;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JID)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JID jid = (JID)object;
        if (this.node != null ? !this.node.equals(jid.node) : jid.node != null) {
            return false;
        }
        if (!this.domain.equals(jid.domain)) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(jid.resource) : jid.resource != null);
    }

    @Override
    public int compareTo(JID jid) {
        int compare = this.domain.compareTo(jid.domain);
        if (compare == 0) {
            String myNode = this.node != null ? this.node : "";
            String hisNode = jid.node != null ? jid.node : "";
            compare = myNode.compareTo(hisNode);
        }
        if (compare == 0) {
            String myResource = this.resource != null ? this.resource : "";
            String hisResource = jid.resource != null ? jid.resource : "";
            compare = myResource.compareTo(hisResource);
        }
        return compare;
    }

    public static boolean equals(String jid1, String jid2) {
        return new JID(jid1).equals(new JID(jid2));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String jid = ExternalizableUtil.getInstance().readSafeUTF(in);
        String[] parts = JID.getParts(jid);
        this.node = parts[0];
        this.domain = parts[1];
        this.resource = parts[2];
        this.updateCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache<K> {
        private static final Object NULL = new Object();
        private final Queue<K> fifoQueue = new ConcurrentLinkedQueue<K>();
        private final Map<K, Object> cachedValues = new ConcurrentHashMap<K, Object>();
        private int maxSize;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void put(K entry) {
            var2_2 = entry;
            synchronized (var2_2) {
                if (this.cachedValues.put(entry, Cache.NULL) == null) {
                    this.fifoQueue.offer(entry);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl14
            }
            do {
                this.cachedValues.remove(this.fifoQueue.poll());
lbl14:
                // 2 sources

            } while (this.cachedValues.size() > this.maxSize);
        }

        public boolean contains(K entry) {
            if (entry == null) {
                return true;
            }
            return this.cachedValues.containsKey(entry);
        }
    }
}

