/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.forms.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.forms.FormField;
import org.jivesoftware.openfire.forms.spi.XFormFieldImpl;

public class XDataFormImpl {
    private String type;
    private String title;
    private List instructions = new ArrayList();
    private List fields = new ArrayList();
    private List reportedFields = new ArrayList();
    private List reportedItems = new ArrayList();

    public XDataFormImpl() {
    }

    public XDataFormImpl(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInstructions(List instructions) {
        this.instructions = instructions;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getInstructions() {
        List list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.instructions)).iterator();
        }
    }

    public FormField getField(String variable) {
        if (variable == null || variable.equals("")) {
            throw new IllegalArgumentException("Variable must not be null or blank.");
        }
        Iterator it = this.getFields();
        while (it.hasNext()) {
            FormField field = (FormField)it.next();
            if (!variable.equals(field.getVariable())) continue;
            return field;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getFields() {
        List list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }
    }

    public int getFieldsSize() {
        return this.fields.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String instruction) {
        List list = this.instructions;
        synchronized (list) {
            this.instructions.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField field) {
        List list = this.fields;
        synchronized (list) {
            this.fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReportedField(FormField field) {
        List list = this.reportedFields;
        synchronized (list) {
            this.reportedFields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFields(ArrayList itemFields) {
        List list = this.reportedItems;
        synchronized (list) {
            this.reportedItems.add(itemFields);
        }
    }

    public String getNamespace() {
        return "jabber:x:data";
    }

    public void setNamespace(String namespace) {
    }

    public String getName() {
        return "x";
    }

    public void setName(String name) {
    }

    public Element asXMLElement() {
        Element x = DocumentHelper.createElement((QName)QName.get((String)"x", (String)"jabber:x:data"));
        if (this.getType() != null) {
            x.addAttribute("type", this.getType());
        }
        if (this.getTitle() != null) {
            x.addElement("title").addText(this.getTitle());
        }
        if (this.instructions.size() > 0) {
            Iterator instrItr = this.getInstructions();
            while (instrItr.hasNext()) {
                x.addElement("instructions").addText((String)instrItr.next());
            }
        }
        if (this.reportedFields.size() > 0) {
            Element reportedElement = x.addElement("reported");
            for (XFormFieldImpl field : this.reportedFields) {
                reportedElement.add(field.asXMLElement());
            }
        }
        if (this.reportedItems.size() > 0) {
            Iterator itemsItr = this.reportedItems.iterator();
            while (itemsItr.hasNext()) {
                Element itemElement = x.addElement("item");
                List fields = (List)itemsItr.next();
                for (XFormFieldImpl field : fields) {
                    itemElement.add(field.asXMLElement());
                }
            }
        }
        if (this.fields.size() > 0) {
            Iterator fieldsItr = this.getFields();
            while (fieldsItr.hasNext()) {
                XFormFieldImpl field = (XFormFieldImpl)fieldsItr.next();
                x.add(field.asXMLElement());
            }
        }
        return x;
    }

    public void parse(Element formElement) {
        this.type = formElement.attributeValue("type");
        Element titleElement = formElement.element("title");
        if (titleElement != null) {
            this.setTitle(titleElement.getTextTrim());
        }
        Iterator instructionElements = formElement.elementIterator("instructions");
        while (instructionElements.hasNext()) {
            this.addInstruction(((Element)instructionElements.next()).getTextTrim());
        }
        Iterator fieldElements = formElement.elementIterator("field");
        while (fieldElements.hasNext()) {
            XFormFieldImpl field = new XFormFieldImpl();
            field.parse((Element)fieldElements.next());
            this.addField(field);
        }
        Element reportedElement = formElement.element("reported");
        if (reportedElement != null) {
            Iterator reportedFieldElements = reportedElement.elementIterator("field");
            while (reportedFieldElements.hasNext()) {
                XFormFieldImpl field = new XFormFieldImpl();
                field.parse((Element)reportedFieldElements.next());
                this.addReportedField(field);
            }
        }
        Iterator itemElements = formElement.elementIterator("item");
        while (itemElements.hasNext()) {
            Element itemElement = (Element)itemElements.next();
            Iterator itemFieldElements = itemElement.elementIterator("field");
            ArrayList<XFormFieldImpl> itemFields = new ArrayList<XFormFieldImpl>();
            while (itemFieldElements.hasNext()) {
                XFormFieldImpl field = new XFormFieldImpl();
                field.parse((Element)itemFieldElements.next());
                itemFields.add(field);
            }
            this.addItemFields(itemFields);
        }
    }
}

