/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform;

import com.install4j.api.ProgressInterface;
import com.install4j.api.UserCanceledException;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.macos.MacosSpecificInstaller;
import com.install4j.runtime.installer.platform.unix.UnixSpecificInstaller;
import com.install4j.runtime.installer.platform.win32.Win32SpecificInstaller;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class PlatformSpecificInstaller {
    private static void installServices(File file, ProgressInterface progressInterface) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getServices();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceConfig serviceConfig = (ServiceConfig)iterator.next();
            if (!serviceConfig.isInstall() || !ComponentConfig.isIncludedInSelectedComponents(serviceConfig.getFile())) continue;
            try {
                if (InstallerUtil.isWindows()) {
                    Win32SpecificInstaller.installService(file, serviceConfig);
                    continue;
                }
                if (!InstallerUtil.isMacOS()) continue;
                MacosSpecificInstaller.installService(file, serviceConfig);
            }
            catch (IOException iOException) {
                progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorInstallService"), serviceConfig.getName()));
            }
        }
    }

    public static void doInstallation(File file, Installer installer, ProgressInterface progressInterface) throws UserCanceledException {
        PlatformSpecificInstaller.installServices(file, progressInterface);
        try {
            if (InstallerUtil.isWindows()) {
                Win32SpecificInstaller.doInstallation(file, installer);
            } else if (InstallerUtil.isMacOS()) {
                MacosSpecificInstaller.doInstallation(file, installer);
            } else {
                UnixSpecificInstaller.doInstallation(file);
            }
        }
        catch (IOException iOException) {
            progressInterface.showFailure(Messages.getMessages().getString("ErrorInstallIcons"));
        }
    }

    public static void doUninstallation(File file, ProgressInterface progressInterface) throws IOException {
        PlatformSpecificInstaller.uninstallServices(file, progressInterface);
        if (InstallerUtil.isWindows()) {
            Win32SpecificInstaller.doUninstallation(file);
        }
    }

    private static void uninstallServices(File file, ProgressInterface progressInterface) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getServices();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceConfig serviceConfig = (ServiceConfig)iterator.next();
            try {
                if (InstallerUtil.isWindows()) {
                    Win32SpecificInstaller.uninstallService(file, serviceConfig);
                    continue;
                }
                if (!InstallerUtil.isMacOS()) continue;
                MacosSpecificInstaller.uninstallService(file, serviceConfig);
            }
            catch (IOException iOException) {
                progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorUninstallService"), serviceConfig.getName()));
            }
        }
    }
}

