/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.ProgressScreen;
import java.text.MessageFormat;

public class InstallationScreen
extends ProgressScreen {
    private Thread installerThread;

    public InstallationScreen(InstallerWizard installerWizard) {
        super(installerWizard);
        this.initScreen();
        FileInstaller.getInstance().setDefaultProgressInterface(this);
    }

    public void setStatusMessage(String string) {
        if (!this.getInstallerWizard().isCancelling()) {
            super.setStatusMessage(string);
        }
    }

    public void setDetailMessage(String string) {
        if (!this.getInstallerWizard().isCancelling()) {
            super.setDetailMessage(string);
        }
    }

    public void setPercentCompleted(int n) {
        if (!this.getInstallerWizard().isCancelling()) {
            super.setPercentCompleted(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        try {
            super.activate();
        }
        finally {
            this.startInstallerThread();
        }
    }

    protected String getTitle() {
        return this.messages.getString("WizardInstalling");
    }

    protected String getSubTitle() {
        return MessageFormat.format(this.messages.getString("InstallingLabel"), this.getApplicationName());
    }

    private void startInstallerThread() {
        this.installerThread = new Thread(){

            public void run() {
                try {
                    InstallerWizard installerWizard = InstallationScreen.this.getInstallerWizard();
                    InstallationScreen.this.fireEvent(2);
                    Installer installer = installerWizard.getInstaller();
                    installer.install(installerWizard.getDestDir(), installerWizard.getSelectedDir());
                    InstallationScreen.this.fireEvent(3);
                    installerWizard.nextScreen();
                }
                catch (Throwable throwable) {
                    Installer.getInstance().reportExeption(throwable);
                    System.exit(1);
                }
            }
        };
        this.installerThread.start();
    }
}

