/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K>
implements ConcurrentMap<K, Object> {
    Map<K, Object> _map;
    ConcurrentMap<K, Object> _cmap;

    public MultiMap() {
        this._map = new HashMap<K, Object>();
    }

    public MultiMap(Map map) {
        if (map instanceof ConcurrentMap) {
            this._cmap = new ConcurrentHashMap<K, Object>(map);
            this._map = this._cmap;
        } else {
            this._map = new HashMap<K, Object>(map);
        }
    }

    public MultiMap(int capacity) {
        this._map = new HashMap<K, Object>(capacity);
    }

    public MultiMap(boolean concurrent) {
        if (concurrent) {
            this._cmap = new ConcurrentHashMap<K, Object>();
            this._map = this._cmap;
        } else {
            this._map = new HashMap<K, Object>();
        }
    }

    public List getValues(Object name) {
        return LazyList.getList(this._map.get(name), true);
    }

    public Object getValue(Object name, int i) {
        Object l = this._map.get(name);
        if (i == 0 && LazyList.size(l) == 0) {
            return null;
        }
        return LazyList.get(l, i);
    }

    public String getString(Object name) {
        Object l = this._map.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o == null ? null : o.toString();
            }
        }
        StringBuilder values = new StringBuilder(128);
        for (int i = 0; i < LazyList.size(l); ++i) {
            Object e = LazyList.get(l, i);
            if (e == null) continue;
            if (values.length() > 0) {
                values.append(',');
            }
            values.append(e.toString());
        }
        return values.toString();
    }

    @Override
    public Object get(Object name) {
        Object l = this._map.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o;
            }
        }
        return LazyList.getList(l, true);
    }

    @Override
    public Object put(K name, Object value) {
        return this._map.put(name, LazyList.add(null, value));
    }

    public Object putValues(K name, List values) {
        return this._map.put(name, values);
    }

    public Object putValues(K name, String[] values) {
        Object list = null;
        for (int i = 0; i < values.length; ++i) {
            list = LazyList.add(list, values[i]);
        }
        return this.put(name, list);
    }

    public void add(K name, Object value) {
        Object ln;
        Object lo = this._map.get(name);
        if (lo != (ln = LazyList.add(lo, value))) {
            this._map.put(name, ln);
        }
    }

    public void addValues(K name, List values) {
        Object ln;
        Object lo = this._map.get(name);
        if (lo != (ln = LazyList.addCollection(lo, values))) {
            this._map.put(name, ln);
        }
    }

    public void addValues(K name, String[] values) {
        Object ln;
        Object lo = this._map.get(name);
        if (lo != (ln = LazyList.addCollection(lo, Arrays.asList(values)))) {
            this._map.put(name, ln);
        }
    }

    public boolean removeValue(K name, Object value) {
        Object lo;
        Object ln = lo = this._map.get(name);
        int s = LazyList.size(lo);
        if (s > 0) {
            ln = LazyList.remove(lo, value);
            if (ln == null) {
                this._map.remove(name);
            } else {
                this._map.put(name, ln);
            }
        }
        return LazyList.size(ln) != s;
    }

    @Override
    public void putAll(Map m) {
        Iterator i = m.entrySet().iterator();
        boolean multi = m instanceof MultiMap;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (multi) {
                this._map.put(entry.getKey(), LazyList.clone(entry.getValue()));
                continue;
            }
            this.put((K)entry.getKey(), entry.getValue());
        }
    }

    public Map toStringArrayMap() {
        HashMap<K, String[]> map = new HashMap<K, String[]>(this._map.size() * 3 / 2);
        for (Map.Entry<K, Object> entry : this._map.entrySet()) {
            Object l = entry.getValue();
            String[] a = LazyList.toStringArray(l);
            map.put(entry.getKey(), a);
        }
        return map;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, Object>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this._map).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._map.keySet();
    }

    @Override
    public Object remove(Object key) {
        return this._map.remove(key);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<Object> values() {
        return this._map.values();
    }

    @Override
    public Object putIfAbsent(K key, Object value) {
        if (this._cmap == null) {
            throw new UnsupportedOperationException();
        }
        return this._cmap.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this._cmap == null) {
            throw new UnsupportedOperationException();
        }
        return this._cmap.remove(key, value);
    }

    @Override
    public boolean replace(K key, Object oldValue, Object newValue) {
        if (this._cmap == null) {
            throw new UnsupportedOperationException();
        }
        return this._cmap.replace(key, oldValue, newValue);
    }

    @Override
    public Object replace(K key, Object value) {
        if (this._cmap == null) {
            throw new UnsupportedOperationException();
        }
        return this._cmap.replace(key, value);
    }
}

