/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.UnavailableException;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.BasicAuthenticator;
import org.mortbay.jetty.security.ClientCertAuthenticator;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.DigestAuthenticator;
import org.mortbay.jetty.security.FormAuthenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

public class WebXmlConfiguration
implements Configuration {
    protected WebAppContext _context;
    protected XmlParser _xmlParser = WebXmlConfiguration.webXmlParser();
    protected Object _filters;
    protected Object _filterMappings;
    protected Object _servlets;
    protected Object _servletMappings;
    protected Object _welcomeFiles;
    protected Object _constraintMappings;
    protected Object _listeners;
    protected Map _errorPages;
    protected boolean _hasJSP;
    protected String _jspServletName;
    protected boolean _defaultWelcomeFileList;

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL dtd23 = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL jsp20xsd = WebAppContext.class.getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL jsp21xsd = WebAppContext.class.getResource("/javax/servlet/resources/jsp_2_1.xsd");
        URL j2ee14xsd = WebAppContext.class.getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL webapp24xsd = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL webapp25xsd = WebAppContext.class.getResource("/javax/servlet/resources/web-app_2_5.xsd");
        URL schemadtd = WebAppContext.class.getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL xmlxsd = WebAppContext.class.getResource("/javax/servlet/resources/xml.xsd");
        URL webservice11xsd = WebAppContext.class.getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL webservice12xsd = WebAppContext.class.getResource("/javax/servlet/resources/javaee_web_services_client_1_2.xsd");
        URL datatypesdtd = WebAppContext.class.getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", dtd22);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        xmlParser.redirectEntity("web.dtd", dtd23);
        xmlParser.redirectEntity("web-app_2_3.dtd", dtd23);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        xmlParser.redirectEntity("XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        xmlParser.redirectEntity("jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("jsp_2_1.xsd", jsp21xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        xmlParser.redirectEntity("j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("web-app_2_5.xsd", webapp25xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        xmlParser.redirectEntity("xml.xsd", xmlxsd);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", xmlxsd);
        xmlParser.redirectEntity("datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("javaee_web_services_client_1_2.xsd", webservice12xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cannot configure webapp after it is started");
            }
            return;
        }
        String defaultsDescriptor = this.getWebAppContext().getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = Resource.newResource(defaultsDescriptor);
            }
            this.configure(dftResource.getURL().toString());
            this._defaultWelcomeFileList = this._welcomeFiles != null;
        }
    }

    public void configureWebApp() throws Exception {
        if (this._context.isStarted()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cannot configure webapp after it is started");
            }
            return;
        }
        URL webxml = this.findWebXml();
        if (webxml != null) {
            this.configure(webxml.toString());
        }
    }

    protected URL findWebXml() throws IOException, MalformedURLException {
        Resource web_inf = this.getWebAppContext().getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web = web_inf.addPath("web.xml");
            if (web.exists()) {
                return web.getURL();
            }
            Log.debug((String)("No WEB-INF/web.xml in " + this.getWebAppContext().getWar() + ". Serving files and default/dynamic servlets only"));
        }
        return null;
    }

    public void configure(String webXml) throws Exception {
        XmlParser.Node config = null;
        config = this._xmlParser.parse(webXml);
        this.initialize(config);
    }

    public void deconfigureWebApp() throws Exception {
        ServletHandler servlet_handler = this.getWebAppContext().getServletHandler();
        servlet_handler.setFilters(null);
        servlet_handler.setFilterMappings(null);
        servlet_handler.setServlets(null);
        servlet_handler.setServletMappings(null);
        this.getWebAppContext().setEventListeners(null);
        this.getWebAppContext().setWelcomeFiles(null);
        if (this.getWebAppContext().getSecurityHandler() != null) {
            this.getWebAppContext().getSecurityHandler().setConstraintMappings(null);
        }
        if (this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(null);
        }
    }

    protected void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        ServletHandler servlet_handler = this.getWebAppContext().getServletHandler();
        this._filters = LazyList.array2List((Object[])servlet_handler.getFilters());
        this._filterMappings = LazyList.array2List((Object[])servlet_handler.getFilterMappings());
        this._servlets = LazyList.array2List((Object[])servlet_handler.getServlets());
        this._servletMappings = LazyList.array2List((Object[])servlet_handler.getServletMappings());
        this._listeners = LazyList.array2List((Object[])this.getWebAppContext().getEventListeners());
        this._welcomeFiles = LazyList.array2List((Object[])this.getWebAppContext().getWelcomeFiles());
        this._constraintMappings = LazyList.array2List((Object[])this.getWebAppContext().getSecurityHandler().getConstraintMappings());
        this._errorPages = this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler ? ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).getErrorPages() : null;
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                this.initWebXmlElement(name, node);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                Log.warn((String)("Configuration problem at " + node), (Throwable)e);
                throw new UnavailableException("Configuration problem");
            }
        }
        servlet_handler.setFilters((FilterHolder[])LazyList.toArray((Object)this._filters, (Class)FilterHolder.class));
        servlet_handler.setFilterMappings((FilterMapping[])LazyList.toArray((Object)this._filterMappings, (Class)FilterMapping.class));
        servlet_handler.setServlets((ServletHolder[])LazyList.toArray((Object)this._servlets, (Class)ServletHolder.class));
        servlet_handler.setServletMappings((ServletMapping[])LazyList.toArray((Object)this._servletMappings, (Class)ServletMapping.class));
        this.getWebAppContext().setEventListeners((EventListener[])LazyList.toArray((Object)this._listeners, (Class)EventListener.class));
        this.getWebAppContext().setWelcomeFiles((String[])LazyList.toArray((Object)this._welcomeFiles, (Class)String.class));
        this.getWebAppContext().getSecurityHandler().setConstraintMappings((ConstraintMapping[])LazyList.toArray((Object)this._constraintMappings, (Class)ConstraintMapping.class));
        if (this._errorPages != null && this.getWebAppContext().getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this.getWebAppContext().getErrorHandler()).setErrorPages(this._errorPages);
        }
    }

    protected void initWebXmlElement(String element, XmlParser.Node node) throws Exception {
        if ("display-name".equals(element)) {
            this.initDisplayName(node);
        } else if (!"description".equals(element)) {
            if ("context-param".equals(element)) {
                this.initContextParam(node);
            } else if ("servlet".equals(element)) {
                this.initServlet(node);
            } else if ("servlet-mapping".equals(element)) {
                this.initServletMapping(node);
            } else if ("session-config".equals(element)) {
                this.initSessionConfig(node);
            } else if ("mime-mapping".equals(element)) {
                this.initMimeConfig(node);
            } else if ("welcome-file-list".equals(element)) {
                this.initWelcomeFileList(node);
            } else if ("locale-encoding-mapping-list".equals(element)) {
                this.initLocaleEncodingList(node);
            } else if ("error-page".equals(element)) {
                this.initErrorPage(node);
            } else if ("taglib".equals(element)) {
                this.initTagLib(node);
            } else if ("jsp-config".equals(element)) {
                this.initJspConfig(node);
            } else if ("resource-ref".equals(element)) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("No implementation: " + node));
                }
            } else if ("security-constraint".equals(element)) {
                this.initSecurityConstraint(node);
            } else if ("login-config".equals(element)) {
                this.initLoginConfig(node);
            } else if ("security-role".equals(element)) {
                this.initSecurityRole(node);
            } else if ("filter".equals(element)) {
                this.initFilter(node);
            } else if ("filter-mapping".equals(element)) {
                this.initFilterMapping(node);
            } else if ("listener".equals(element)) {
                this.initListener(node);
            } else if ("distributable".equals(element)) {
                this.initDistributable(node);
            } else if (Log.isDebugEnabled()) {
                Log.debug((String)"Element {} not handled in {}", (Object)element, (Object)this);
                Log.debug((String)node.toString());
            }
        }
    }

    protected void initDisplayName(XmlParser.Node node) {
        this.getWebAppContext().setDisplayName(node.toString(false, true));
    }

    protected void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("ContextParam: " + name + "=" + value));
        }
        this.getWebAppContext().getInitParams().put(name, value);
    }

    protected void initFilter(XmlParser.Node node) {
        FilterHolder holder = this.newFilterHolder();
        holder.setName(node.getString("filter-name", false, true));
        holder.setClassName(node.getString("filter-class", false, true));
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        this._filters = LazyList.add((Object)this._filters, (Object)holder);
    }

    protected void initFilterMapping(XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filter_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        int dispatcher = 0;
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatcher |= Dispatcher.type(d);
        }
        mapping.setDispatches(dispatcher);
        this._filterMappings = LazyList.add((Object)this._filterMappings, (Object)mapping);
    }

    protected void initServlet(XmlParser.Node node) {
        String roleName;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        String servlet_class = node.getString("servlet-class", false, true);
        ServletHolder holder = this.newServletHolder();
        holder.setName(servlet_name);
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.setInitParameter(pname, pvalue);
        }
        if (id != null && id.equals("jsp")) {
            this._jspServletName = servlet_name;
            try {
                Loader.loadClass(this.getClass(), (String)servlet_class);
                this._hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                Log.info((String)"NO JSP Support for {}, did not find {}", (Object)this._context.getContextPath(), (Object)servlet_class);
                this._hasJSP = false;
                servlet_class = "org.mortbay.servlet.NoJspServlet";
            }
            if (holder.getInitParameter("scratchdir") == null) {
                File tmp = this.getWebAppContext().getTempDirectory();
                File scratch = new File(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdir();
                }
                holder.setInitParameter("scratchdir", scratch.getAbsolutePath());
            }
        }
        holder.setClassName(servlet_class);
        String jsp_file = node.getString("jsp-file", false, true);
        holder.setForcedPath(jsp_file);
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Log.warn((String)"Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Log.warn((String)("Cannot parse load-on-startup " + s + ". Please use integer"));
                    Log.ignore((Throwable)e);
                }
                holder.setInitOrder(order);
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("link role " + roleName + " to " + roleLink + " for " + this));
                }
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            Log.warn((String)("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef));
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAs(roleName);
        }
        this._servlets = LazyList.add((Object)this._servlets, (Object)holder);
    }

    protected void initServletMapping(XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servlet_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        this._servletMappings = LazyList.add((Object)this._servletMappings, (Object)mapping);
    }

    protected void initListener(XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            Class listenerClass = this.getWebAppContext().loadClass(className);
            listener = this.newListenerInstance(listenerClass);
            if (!(listener instanceof EventListener)) {
                Log.warn((String)("Not an EventListener: " + listener));
                return;
            }
            this._listeners = LazyList.add((Object)this._listeners, (Object)listener);
        }
        catch (Exception e) {
            Log.warn((String)("Could not instantiate listener " + className), (Throwable)e);
            return;
        }
    }

    protected Object newListenerInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    protected void initDistributable(XmlParser.Node node) {
        WebAppContext wac = this.getWebAppContext();
        if (!wac.isDistributable()) {
            wac.setDistributable(true);
        }
    }

    protected void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getWebAppContext().getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
    }

    protected void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.getWebAppContext().getMimeTypes().addMimeMapping(extension, mimeType);
    }

    protected void initWelcomeFileList(XmlParser.Node node) {
        if (this._defaultWelcomeFileList) {
            this._welcomeFiles = null;
        }
        this._defaultWelcomeFileList = false;
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            this._welcomeFiles = LazyList.add((Object)this._welcomeFiles, (Object)welcome);
        }
    }

    protected void initLocaleEncodingList(XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            this.getWebAppContext().addLocaleEncoding(locale, encoding);
        }
    }

    protected void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(error, location);
    }

    protected void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this.getWebAppContext().setResourceAlias(uri, location);
    }

    protected void initJspConfig(XmlParser.Node node) {
        String jspName;
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.initTagLib((XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        Object paths = null;
        while (iter.hasNext()) {
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                paths = LazyList.add(paths, (Object)url);
            }
        }
        if (LazyList.size(paths) > 0 && (jspName = this.getJSPServletName()) != null) {
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(jspName);
            mapping.setPathSpecs(LazyList.toStringArray(paths));
            this._servletMappings = LazyList.add((Object)this._servletMappings, (Object)mapping);
        }
    }

    protected void initSecurityConstraint(XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                Object roles = null;
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles = LazyList.add(roles, (Object)role);
                }
                scBase.setRoles(LazyList.toStringArray(roles));
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    Log.warn((String)("Unknown user-data-constraint:" + guarantee));
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            this._constraintMappings = LazyList.add((Object)this._constraintMappings, (Object)mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    this._constraintMappings = LazyList.add((Object)this._constraintMappings, (Object)mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            Log.warn((Throwable)e);
        }
    }

    protected void initLoginConfig(XmlParser.Node node) {
        XmlParser.Node formConfig;
        XmlParser.Node name;
        XmlParser.Node method = node.get("auth-method");
        FormAuthenticator _formAuthenticator = null;
        if (method != null) {
            Authenticator authenticator = null;
            String m = method.toString(false, true);
            if ("FORM".equals(m)) {
                authenticator = _formAuthenticator = new FormAuthenticator();
            } else if ("BASIC".equals(m)) {
                authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(m)) {
                authenticator = new DigestAuthenticator();
            } else if ("CLIENT_CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else if ("CLIENT-CERT".equals(m)) {
                authenticator = new ClientCertAuthenticator();
            } else {
                Log.warn((String)("UNKNOWN AUTH METHOD: " + m));
            }
            this.getWebAppContext().getSecurityHandler().setAuthenticator(authenticator);
        }
        if ((name = node.get("realm-name")) != null) {
            String realm_name = name.toString(false, true);
            UserRealm[] realms = ContextHandler.getCurrentContext().getContextHandler().getServer().getUserRealms();
            UserRealm realm = this.getWebAppContext().getSecurityHandler().getUserRealm();
            for (int i = 0; realm == null && realms != null && i < realms.length; ++i) {
                if (realms[i] == null || !realm_name.equals(realms[i].getName())) continue;
                realm = realms[i];
            }
            if (realm == null) {
                String msg = "Unknown realm: " + realm_name;
                Log.warn((String)msg);
            } else {
                this.getWebAppContext().getSecurityHandler().setUserRealm(realm);
            }
        }
        if ((formConfig = node.get("form-login-config")) != null) {
            if (_formAuthenticator == null) {
                Log.warn((String)"FORM Authentication miss-configured");
            } else {
                XmlParser.Node errorPage;
                XmlParser.Node loginPage = formConfig.get("form-login-page");
                if (loginPage != null) {
                    _formAuthenticator.setLoginPage(loginPage.toString(false, true));
                }
                if ((errorPage = formConfig.get("form-error-page")) != null) {
                    String ep = errorPage.toString(false, true);
                    _formAuthenticator.setErrorPage(ep);
                }
            }
        }
    }

    protected void initSecurityRole(XmlParser.Node node) {
    }

    protected ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    protected FilterHolder newFilterHolder() {
        return new FilterHolder();
    }

    protected String getJSPServletName() {
        PathMap.Entry entry;
        if (this._jspServletName == null && (entry = this._context.getServletHandler().getHolderEntry("test.jsp")) != null) {
            ServletHolder holder = (ServletHolder)entry.getValue();
            this._jspServletName = holder.getName();
        }
        return this._jspServletName;
    }
}

