/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.packet.Transcripts;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TranscriptsProvider
implements IQProvider {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    @Override
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        String userID = parser.getAttributeValue("", "userID");
        ArrayList<Transcripts.TranscriptSummary> summaries = new ArrayList<Transcripts.TranscriptSummary>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("transcript")) continue;
                summaries.add(this.parseSummary(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("transcripts")) continue;
            done = true;
        }
        return new Transcripts(userID, summaries);
    }

    private Transcripts.TranscriptSummary parseSummary(XmlPullParser parser) throws IOException, XmlPullParserException {
        String sessionID = parser.getAttributeValue("", "sessionID");
        Date joinTime = null;
        Date leftTime = null;
        List<Transcripts.AgentDetail> agents = new ArrayList<Transcripts.AgentDetail>();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("joinTime")) {
                    try {
                        joinTime = UTC_FORMAT.parse(parser.nextText());
                    }
                    catch (ParseException e) {}
                    continue;
                }
                if (parser.getName().equals("leftTime")) {
                    try {
                        leftTime = UTC_FORMAT.parse(parser.nextText());
                    }
                    catch (ParseException e) {}
                    continue;
                }
                if (!parser.getName().equals("agents")) continue;
                agents = this.parseAgents(parser);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("transcript")) continue;
            done = true;
        }
        return new Transcripts.TranscriptSummary(sessionID, joinTime, leftTime, agents);
    }

    private List<Transcripts.AgentDetail> parseAgents(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<Transcripts.AgentDetail> agents = new ArrayList<Transcripts.AgentDetail>();
        String agentJID = null;
        Date joinTime = null;
        Date leftTime = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("agentJID")) {
                    agentJID = parser.nextText();
                    continue;
                }
                if (parser.getName().equals("joinTime")) {
                    try {
                        joinTime = UTC_FORMAT.parse(parser.nextText());
                    }
                    catch (ParseException e) {}
                    continue;
                }
                if (parser.getName().equals("leftTime")) {
                    try {
                        leftTime = UTC_FORMAT.parse(parser.nextText());
                    }
                    catch (ParseException e) {}
                    continue;
                }
                if (!parser.getName().equals("agent")) continue;
                agentJID = null;
                joinTime = null;
                leftTime = null;
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("agents")) {
                done = true;
                continue;
            }
            if (!parser.getName().equals("agent")) continue;
            agents.add(new Transcripts.AgentDetail(agentJID, joinTime, leftTime));
        }
        return agents;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }
}

