/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T argument, String errorMessage) {
        if (argument == null) {
            throw new NullPointerException(errorMessage);
        }
        return argument;
    }

    public static String checkHasText(String argument, String errorMessage) {
        if (argument == null || argument.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument;
    }

    public static <E> E isNotNull(E argument, String argName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be null", argName));
        }
        return argument;
    }

    public static long checkNotNegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkNotNegative(int value, String errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static long checkNegative(long value, String errorMessage) {
        if (value >= 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static long checkPositive(long value, String errorMessage) {
        if (value <= 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkPositive(int value, String errorMessage) {
        if (value <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkBackupCount(int newBackupCount, int currentAsyncBackupCount) {
        if (newBackupCount < 0) {
            throw new IllegalArgumentException("backup-count can't be smaller than 0");
        }
        if (currentAsyncBackupCount < 0) {
            throw new IllegalArgumentException("async-backup-count can't be smaller than 0");
        }
        if (newBackupCount > 6) {
            throw new IllegalArgumentException("backup-count can't be larger than than 6");
        }
        if (newBackupCount + currentAsyncBackupCount > 6) {
            throw new IllegalArgumentException("the sum of backup-count and async-backup-count can't be larger than than 6");
        }
        return newBackupCount;
    }

    public static int checkAsyncBackupCount(int currentBackupCount, int newAsyncBackupCount) {
        if (currentBackupCount < 0) {
            throw new IllegalArgumentException("backup-count can't be smaller than 0");
        }
        if (newAsyncBackupCount < 0) {
            throw new IllegalArgumentException("async-backup-count can't be smaller than 0");
        }
        if (newAsyncBackupCount > 6) {
            throw new IllegalArgumentException("async-backup-count can't be larger than than 6");
        }
        if (currentBackupCount + newAsyncBackupCount > 6) {
            throw new IllegalArgumentException("the sum of backup-count and async-backup-count can't be larger than than 6");
        }
        return newAsyncBackupCount;
    }

    public static <E> E checkInstanceOf(Class type, E object, String errorMessage) {
        Preconditions.isNotNull(type, "type");
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return object;
    }

    public static <E> E checkNotInstanceOf(Class type, E object, String errorMessage) {
        Preconditions.isNotNull(type, "type");
        if (type.isInstance(object)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return object;
    }

    public static void checkFalse(boolean expression, String errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkTrue(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

