/*
 * Decompiled with CFR 0.152.
 */
package org.jugbb.ant.propertymerge;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.jugbb.ant.propertymerge.UnicodeConverter;

public class PropertyMergeTask
extends Task {
    private String inputPropertyFile;
    private boolean ignoreMissingMergeFile = true;
    private String inputPropertyFileEncoding = "UTF-8";
    private Properties inputProperties = new Properties();
    private String mergePropertyFile;
    private String mergePropertyFileEncoding = null;
    private Properties mergeProperties = new Properties();
    private String outputPropertyFile;
    private String outputFileOSType = "UNIX";
    private String outputPropertyFileEncoding = null;
    private boolean native2Ascii = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.inputPropertyFile == null || this.inputPropertyFile.length() == 0) {
            throw new BuildException("inputPropertyFile attribute cannot be null or empty");
        }
        File inputFile = new File(this.inputPropertyFile);
        if (!inputFile.exists() || !inputFile.canRead()) {
            throw new BuildException("inputPropertyFile " + inputFile.getAbsolutePath() + " does not exists or cannot be read");
        }
        if (inputFile.length() == 0L) {
            this.log("inputPropertyFile is empty", LogLevel.WARN.getLevel());
        }
        try {
            this.log("Load input properties " + inputFile.getAbsolutePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), this.inputPropertyFileEncoding));
            if (reader != null) {
                this.inputProperties.load(reader);
                ((Reader)reader).close();
            }
            this.log("Input properties loaded with " + this.inputProperties.size() + " entries");
        }
        catch (Exception e) {
            throw new BuildException("load inputProperties failed: " + e.getMessage(), (Throwable)e);
        }
        if (this.mergePropertyFile == null || this.mergePropertyFile.length() == 0) {
            throw new BuildException("mergePropertyFile attribute cannot be null or empty");
        }
        File mergeFile = new File(this.mergePropertyFile);
        if (!mergeFile.exists() || !mergeFile.canRead()) {
            if (!this.ignoreMissingMergeFile) throw new BuildException("mergePropertyFile " + mergeFile.getAbsolutePath() + " does not exists or cannot be read");
            this.log("Nothing to merge, task ends.");
        } else if (mergeFile.length() == 0L) {
            this.log("mergePropertyFile is empty", LogLevel.WARN.getLevel());
        }
        if (this.mergePropertyFileEncoding == null) {
            this.mergePropertyFileEncoding = this.inputPropertyFileEncoding;
        }
        try {
            this.log("Load merge properties " + mergeFile.getAbsolutePath());
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(mergeFile), this.mergePropertyFileEncoding));
            if (reader != null) {
                this.mergeProperties.load(reader);
                ((Reader)reader).close();
            }
            this.log("Merge properties loaded with " + this.mergeProperties.size() + " entries");
        }
        catch (Exception e) {
            throw new BuildException("load inputProperties failed: " + e.getMessage(), (Throwable)e);
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(this.inputProperties);
        int countUpdatedWithMerge = 0;
        int countAddedFromMerge = 0;
        for (Map.Entry<Object, Object> mergeMapEntry : this.mergeProperties.entrySet()) {
            Object mergeKey = mergeMapEntry.getKey();
            if (treeMap.containsKey(mergeKey)) {
                treeMap.remove(mergeKey);
                if (mergeMapEntry.getValue() == null) continue;
                treeMap.put(mergeKey.toString(), mergeMapEntry.getValue().toString());
                ++countUpdatedWithMerge;
                continue;
            }
            if (mergeMapEntry.getValue() == null) continue;
            treeMap.put(mergeKey.toString(), mergeMapEntry.getValue().toString());
            ++countAddedFromMerge;
        }
        this.log("Properties merged: " + countAddedFromMerge + " entries added, " + countUpdatedWithMerge + " entries value changed.");
        try {
            if (this.outputPropertyFile == null || this.outputPropertyFile.length() == 0) {
                throw new BuildException("outputPropertyFile attribute cannot be null or empty");
            }
            File outputFile = new File(this.outputPropertyFile);
            if (this.native2Ascii) {
                this.outputPropertyFileEncoding = "ASCII";
            } else if (this.outputPropertyFileEncoding == null) {
                this.outputPropertyFileEncoding = this.inputPropertyFileEncoding;
            }
            this.log("Write output to " + outputFile.getAbsolutePath());
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, false), this.outputPropertyFileEncoding));
            for (Map.Entry<Object, Object> entry : treeMap.entrySet()) {
                writer.append((CharSequence)entry.getKey());
                writer.append("=");
                if (entry.getValue() != null) {
                    if (this.native2Ascii) {
                        writer.append(UnicodeConverter.getStringWithUnicodeLiterals((String)entry.getValue()));
                    } else {
                        writer.append((CharSequence)entry.getValue());
                    }
                }
                if ("UNIX".equalsIgnoreCase(this.outputFileOSType)) {
                    writer.append("\n");
                    continue;
                }
                if ("WINDOWS".equalsIgnoreCase(this.outputFileOSType)) {
                    writer.append("\r\n");
                    continue;
                }
                writer.append("\n");
            }
            ((Writer)writer).close();
            this.log("Output properties sorted and written with " + treeMap.size() + " entries.");
            return;
        }
        catch (Exception e) {
            throw new BuildException("write output failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getInputPropertyFile() {
        return this.inputPropertyFile;
    }

    public void setInputPropertyFile(String inputPropertyFile) {
        this.inputPropertyFile = inputPropertyFile;
    }

    public String getMergePropertyFile() {
        return this.mergePropertyFile;
    }

    public void setMergePropertyFile(String mergePropertyFile) {
        this.mergePropertyFile = mergePropertyFile;
    }

    public String getOutputPropertyFile() {
        return this.outputPropertyFile;
    }

    public void setOutputPropertyFile(String outputPropertyFile) {
        this.outputPropertyFile = outputPropertyFile;
    }

    public String getInputPropertyFileEncoding() {
        return this.inputPropertyFileEncoding;
    }

    public void setInputPropertyFileEncoding(String inputPropertyFileEncoding) {
        this.inputPropertyFileEncoding = inputPropertyFileEncoding;
    }

    public String getMergePropertyFileEncoding() {
        return this.mergePropertyFileEncoding;
    }

    public void setMergePropertyFileEncoding(String mergePropertyFileEncoding) {
        this.mergePropertyFileEncoding = mergePropertyFileEncoding;
    }

    public String getOutputPropertyFileEncoding() {
        return this.outputPropertyFileEncoding;
    }

    public void setOutputPropertyFileEncoding(String outputPropertyFileEncoding) {
        this.outputPropertyFileEncoding = outputPropertyFileEncoding;
    }

    public String getDescription() {
        return "Task to merge two properties and save it as new property file";
    }

    public String getNative2Ascii() {
        return String.valueOf(this.native2Ascii);
    }

    public void setNative2Ascii(String native2AsciiStr) {
        this.native2Ascii = Boolean.valueOf(native2AsciiStr);
    }

    public void setIgnoreMissingMergeFile(String ignore) {
        this.ignoreMissingMergeFile = Boolean.valueOf(ignore);
    }

    public String getIgnoreMissingMergeFile() {
        return String.valueOf(this.ignoreMissingMergeFile);
    }
}

