/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.MockSettings;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.debugging.VerboseMockInvocationLogger;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.Checks;
import org.mockito.internal.util.MockCreationValidator;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.collections.Sets;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.mock.SerializableMode;
import org.mockito.stubbing.Answer;

public class MockSettingsImpl<T>
extends CreationSettings<T>
implements MockSettings,
MockCreationSettings<T> {
    private static final long serialVersionUID = 4475297236197939569L;
    private boolean useConstructor;
    private Object outerClassInstance;
    private Object[] constructorArgs;

    @Override
    public MockSettings serializable() {
        return this.serializable(SerializableMode.BASIC);
    }

    @Override
    public MockSettings serializable(SerializableMode mode) {
        this.serializableMode = mode;
        return this;
    }

    @Override
    public MockSettings extraInterfaces(Class<?> ... extraInterfaces) {
        if (extraInterfaces == null || extraInterfaces.length == 0) {
            throw Reporter.extraInterfacesRequiresAtLeastOneInterface();
        }
        for (Class<?> i : extraInterfaces) {
            if (i == null) {
                throw Reporter.extraInterfacesDoesNotAcceptNullParameters();
            }
            if (i.isInterface()) continue;
            throw Reporter.extraInterfacesAcceptsOnlyInterfaces(i);
        }
        this.extraInterfaces = Sets.newSet(extraInterfaces);
        return this;
    }

    @Override
    public MockName getMockName() {
        return this.mockName;
    }

    @Override
    public Set<Class<?>> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    @Override
    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public MockSettings name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MockSettings spiedInstance(Object spiedInstance) {
        this.spiedInstance = spiedInstance;
        return this;
    }

    @Override
    public MockSettings defaultAnswer(Answer defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
        if (defaultAnswer == null) {
            throw Reporter.defaultAnswerDoesNotAcceptNullParameter();
        }
        return this;
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    public MockSettingsImpl<T> stubOnly() {
        this.stubOnly = true;
        return this;
    }

    @Override
    public MockSettings useConstructor(Object ... constructorArgs) {
        Checks.checkNotNull(constructorArgs, "constructorArgs", "If you need to pass null, please cast it to the right type, e.g.: useConstructor((String) null)");
        this.useConstructor = true;
        this.constructorArgs = constructorArgs;
        return this;
    }

    @Override
    public MockSettings outerInstance(Object outerClassInstance) {
        this.outerClassInstance = outerClassInstance;
        return this;
    }

    @Override
    public boolean isUsingConstructor() {
        return this.useConstructor;
    }

    @Override
    public Object getOuterClassInstance() {
        return this.outerClassInstance;
    }

    @Override
    public Object[] getConstructorArgs() {
        if (this.outerClassInstance == null) {
            return this.constructorArgs;
        }
        ArrayList<Object> resultArgs = new ArrayList<Object>(this.constructorArgs.length + 1);
        resultArgs.add(this.outerClassInstance);
        resultArgs.addAll(Arrays.asList(this.constructorArgs));
        return resultArgs.toArray(new Object[this.constructorArgs.length + 1]);
    }

    @Override
    public boolean isStubOnly() {
        return this.stubOnly;
    }

    @Override
    public MockSettings verboseLogging() {
        if (!this.invocationListenersContainsType(VerboseMockInvocationLogger.class)) {
            this.invocationListeners(new VerboseMockInvocationLogger());
        }
        return this;
    }

    @Override
    public MockSettings invocationListeners(InvocationListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            throw Reporter.invocationListenersRequiresAtLeastOneListener();
        }
        for (InvocationListener listener : listeners) {
            if (listener == null) {
                throw Reporter.invocationListenerDoesNotAcceptNullParameters();
            }
            this.invocationListeners.add(listener);
        }
        return this;
    }

    private boolean invocationListenersContainsType(Class<?> clazz) {
        for (InvocationListener listener : this.invocationListeners) {
            if (!listener.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<InvocationListener> getInvocationListeners() {
        return this.invocationListeners;
    }

    public boolean hasInvocationListeners() {
        return !this.invocationListeners.isEmpty();
    }

    @Override
    public Class<T> getTypeToMock() {
        return this.typeToMock;
    }

    @Override
    public <T> MockCreationSettings<T> build(Class<T> typeToMock) {
        return MockSettingsImpl.validatedSettings(typeToMock, this);
    }

    private static <T> CreationSettings<T> validatedSettings(Class<T> typeToMock, CreationSettings<T> source) {
        MockCreationValidator validator = new MockCreationValidator();
        validator.validateType(typeToMock);
        validator.validateExtraInterfaces(typeToMock, source.getExtraInterfaces());
        validator.validateMockedType(typeToMock, source.getSpiedInstance());
        validator.validateConstructorUse(source.isUsingConstructor(), source.getSerializableMode());
        CreationSettings<T> settings = new CreationSettings<T>(source);
        settings.setMockName(new MockNameImpl(source.getName(), typeToMock));
        settings.setTypeToMock(typeToMock);
        settings.setExtraInterfaces(MockSettingsImpl.prepareExtraInterfaces(source));
        return settings;
    }

    private static Set<Class<?>> prepareExtraInterfaces(CreationSettings settings) {
        HashSet interfaces = new HashSet(settings.getExtraInterfaces());
        if (settings.isSerializable()) {
            interfaces.add(Serializable.class);
        }
        return interfaces;
    }
}

