/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.CaptureDeviceInfo;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.device.AbstractMediaDevice;
import org.jitsi.impl.neomedia.format.MediaFormatImpl;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferCaptureDevice;
import org.jitsi.impl.neomedia.protocol.CaptureDeviceDelegatePushBufferDataSource;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.ScreenDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;

public class MediaDeviceImpl
extends AbstractMediaDevice {
    private static final Logger logger = Logger.getLogger(MediaDeviceImpl.class);
    private final CaptureDeviceInfo captureDeviceInfo;
    private final MediaType mediaType;

    public static CaptureDevice createTracingCaptureDevice(CaptureDevice captureDevice, final Logger logger) {
        if (captureDevice instanceof PushBufferDataSource) {
            captureDevice = new CaptureDeviceDelegatePushBufferDataSource(captureDevice){

                @Override
                public void connect() throws IOException {
                    super.connect();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Connected " + MediaDeviceImpl.toString(this.captureDevice));
                    }
                }

                @Override
                public void disconnect() {
                    super.disconnect();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Disconnected " + MediaDeviceImpl.toString(this.captureDevice));
                    }
                }

                @Override
                public void start() throws IOException {
                    super.start();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Started " + MediaDeviceImpl.toString(this.captureDevice));
                    }
                }

                @Override
                public void stop() throws IOException {
                    super.stop();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Stopped " + MediaDeviceImpl.toString(this.captureDevice));
                    }
                }
            };
        }
        return captureDevice;
    }

    private static String toString(CaptureDevice captureDevice) {
        StringBuffer str = new StringBuffer();
        str.append("CaptureDevice with hashCode ");
        str.append(captureDevice.hashCode());
        str.append(" and captureDeviceInfo ");
        CaptureDeviceInfo captureDeviceInfo = captureDevice.getCaptureDeviceInfo();
        MediaLocator mediaLocator = null;
        if (captureDeviceInfo != null) {
            mediaLocator = captureDeviceInfo.getLocator();
        }
        str.append(mediaLocator == null ? captureDeviceInfo : mediaLocator);
        return str.toString();
    }

    public MediaDeviceImpl(CaptureDeviceInfo captureDeviceInfo, MediaType mediaType) {
        if (captureDeviceInfo == null) {
            throw new NullPointerException("captureDeviceInfo");
        }
        if (mediaType == null) {
            throw new NullPointerException("mediaType");
        }
        this.captureDeviceInfo = captureDeviceInfo;
        this.mediaType = mediaType;
    }

    public MediaDeviceImpl(MediaType mediaType) {
        this.captureDeviceInfo = null;
        this.mediaType = mediaType;
    }

    protected CaptureDevice createCaptureDevice() {
        CaptureDevice captureDevice = null;
        if (this.getDirection().allowsSending()) {
            CaptureDeviceInfo captureDeviceInfo = this.getCaptureDeviceInfo();
            Exception exception = null;
            try {
                captureDevice = (CaptureDevice)((Object)Manager.createDataSource(captureDeviceInfo.getLocator()));
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            catch (NoDataSourceException ndse) {
                exception = ndse;
            }
            if (exception != null) {
                logger.error("Failed to create CaptureDevice from CaptureDeviceInfo " + captureDeviceInfo, exception);
            } else {
                if (captureDevice instanceof AbstractPullBufferCaptureDevice) {
                    ((AbstractPullBufferCaptureDevice)captureDevice).setCaptureDeviceInfo(captureDeviceInfo);
                }
                if (logger.isTraceEnabled()) {
                    captureDevice = MediaDeviceImpl.createTracingCaptureDevice(captureDevice, logger);
                }
            }
        }
        return captureDevice;
    }

    @Override
    protected DataSource createOutputDataSource() {
        return this.getDirection().allowsSending() ? (DataSource)((Object)this.createCaptureDevice()) : null;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.captureDeviceInfo;
    }

    public String getCaptureDeviceInfoLocatorProtocol() {
        MediaLocator locator;
        CaptureDeviceInfo cdi = this.getCaptureDeviceInfo();
        if (cdi != null && (locator = cdi.getLocator()) != null) {
            return locator.getProtocol();
        }
        return null;
    }

    @Override
    public MediaDirection getDirection() {
        if (this.getCaptureDeviceInfo() != null) {
            return MediaDirection.SENDRECV;
        }
        return MediaType.AUDIO.equals((Object)this.getMediaType()) ? MediaDirection.INACTIVE : MediaDirection.RECVONLY;
    }

    @Override
    public MediaFormat getFormat() {
        CaptureDevice captureDevice = this.createCaptureDevice();
        if (captureDevice != null) {
            MediaType mediaType = this.getMediaType();
            for (FormatControl formatControl : captureDevice.getFormatControls()) {
                MediaFormat format = MediaFormatImpl.createInstance(formatControl.getFormat());
                if (format == null || !format.getMediaType().equals((Object)mediaType)) continue;
                return format;
            }
        }
        return null;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public List<MediaFormat> getSupportedFormats(EncodingConfiguration encodingConfiguration) {
        return this.getSupportedFormats(null, null, encodingConfiguration);
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset sendPreset, QualityPreset receivePreset) {
        return this.getSupportedFormats(sendPreset, receivePreset, NeomediaServiceUtils.getMediaServiceImpl().getCurrentEncodingConfiguration());
    }

    @Override
    public List<MediaFormat> getSupportedFormats(QualityPreset sendPreset, QualityPreset receivePreset, EncodingConfiguration encodingConfiguration) {
        MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
        MediaFormat[] enabledEncodings = encodingConfiguration.getEnabledEncodings(this.getMediaType());
        ArrayList<MediaFormat> supportedFormats = new ArrayList<MediaFormat>();
        if (enabledEncodings != null) {
            for (MediaFormat f : enabledEncodings) {
                if ("h264".equalsIgnoreCase(f.getEncoding())) {
                    ScreenDevice screen;
                    MediaLocator captureDeviceInfoLocator;
                    Map<String, String> h264AdvancedAttributes = f.getAdvancedAttributes();
                    if (h264AdvancedAttributes == null) {
                        h264AdvancedAttributes = new HashMap<String, String>();
                    }
                    CaptureDeviceInfo captureDeviceInfo = this.getCaptureDeviceInfo();
                    Dimension sendSize = null;
                    if (captureDeviceInfo != null && (captureDeviceInfoLocator = captureDeviceInfo.getLocator()) != null && !"imgstreaming".equals(captureDeviceInfoLocator.getProtocol()) && sendPreset != null) {
                        sendSize = sendPreset.getResolution();
                    }
                    Dimension receiveSize = receivePreset != null ? receivePreset.getResolution() : ((screen = mediaServiceImpl.getDefaultScreenDevice()) == null ? null : screen.getSize());
                    h264AdvancedAttributes.put("imageattr", MediaUtils.createImageAttr(sendSize, receiveSize));
                    f = mediaServiceImpl.getFormatFactory().createMediaFormat(f.getEncoding(), f.getClockRate(), f.getFormatParameters(), h264AdvancedAttributes);
                }
                if (f == null) continue;
                supportedFormats.add(f);
            }
        }
        return supportedFormats;
    }

    public String toString() {
        CaptureDeviceInfo captureDeviceInfo = this.getCaptureDeviceInfo();
        return captureDeviceInfo == null ? super.toString() : captureDeviceInfo.toString();
    }
}

