/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;

public abstract class MessageProcessor
implements Runnable {
    protected static final String IN_ADDR_ANY = "0.0.0.0";
    protected static final String IN6_ADDR_ANY = "::0";
    private String sentBy;
    private HostPort sentByHostPort;
    private String savedIpAddress;
    private InetAddress ipAddress;
    private int port;
    protected String transport;
    private ListeningPointImpl listeningPoint;
    private boolean sentBySet;

    public MessageProcessor(InetAddress inetAddress, int n, String string) {
        this.savedIpAddress = inetAddress.getHostAddress();
        this.ipAddress = inetAddress;
        this.port = n;
        this.transport = string;
        this.sentByHostPort = new HostPort();
        this.sentByHostPort.setHost(new Host(inetAddress.getHostAddress()));
        this.sentByHostPort.setPort(n);
    }

    public String getTransport() {
        return this.transport;
    }

    public int getPort() {
        return this.port;
    }

    public Via getViaHeader() {
        try {
            Via via = new Via();
            if (this.sentByHostPort != null) {
                via.setSentBy(this.sentByHostPort);
                via.setTransport(this.getTransport());
            } else {
                Host host = new Host();
                host.setHostname(this.getIpAddress().getHostAddress());
                via.setHost(host);
                via.setPort(this.getPort());
                via.setTransport(this.getTransport());
            }
            return via;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        catch (InvalidArgumentException invalidArgumentException) {
            invalidArgumentException.printStackTrace();
            return null;
        }
    }

    public ListeningPointImpl getListeningPoint() {
        if (this.listeningPoint == null && this.getSIPStack().isLoggingEnabled()) {
            this.getSIPStack().getLogWriter().logError("getListeningPoint" + this + " returning null listeningpoint");
        }
        return this.listeningPoint;
    }

    public void setListeningPoint(ListeningPointImpl listeningPointImpl) {
        if (this.getSIPStack().isLoggingEnabled()) {
            this.getSIPStack().getLogWriter().logDebug("setListeningPoint" + this + " listeningPoint = " + listeningPointImpl);
        }
        if (listeningPointImpl.getPort() != this.getPort()) {
            InternalErrorHandler.handleException("lp mismatch with provider", this.getSIPStack().logWriter);
        }
        this.listeningPoint = listeningPointImpl;
    }

    public String getSavedIpAddress() {
        return this.savedIpAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    protected void setIpAddress(InetAddress inetAddress) {
        this.sentByHostPort.setHost(new Host(inetAddress.getHostAddress()));
        this.ipAddress = inetAddress;
    }

    public void setSentBy(String string) throws ParseException {
        int n = string.indexOf(":");
        if (n == -1) {
            this.sentByHostPort = new HostPort();
            this.sentByHostPort.setHost(new Host(string));
        } else {
            this.sentByHostPort = new HostPort();
            this.sentByHostPort.setHost(new Host(string.substring(0, n)));
            String string2 = string.substring(n + 1);
            try {
                int n2 = Integer.parseInt(string2);
                this.sentByHostPort.setPort(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Bad format encountered at ", n);
            }
        }
        this.sentBySet = true;
        this.sentBy = string;
    }

    public String getSentBy() {
        if (this.sentBy == null && this.sentByHostPort != null) {
            this.sentBy = this.sentByHostPort.toString();
        }
        return this.sentBy;
    }

    public abstract SIPTransactionStack getSIPStack();

    public abstract MessageChannel createMessageChannel(HostPort var1) throws IOException;

    public abstract MessageChannel createMessageChannel(InetAddress var1, int var2) throws IOException;

    public abstract void start() throws IOException;

    public abstract void stop();

    public abstract int getDefaultTargetPort();

    public abstract boolean isSecure();

    public abstract int getMaximumMessageSize();

    public abstract boolean inUse();

    public abstract void run();

    public boolean isSentBySet() {
        return this.sentBySet;
    }

    public static int getDefaultPort(String string) {
        return string.equalsIgnoreCase("TLS") ? 5061 : 5060;
    }
}

